% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseIndication.R
\name{summariseIndication}
\alias{summariseIndication}
\title{Summarise the indications of individuals in a drug cohort}
\usage{
summariseIndication(
  cohort,
  strata = list(),
  indicationCohortName,
  indicationCohortId = NULL,
  indicationWindow = list(c(0, 0)),
  unknownIndicationTable = NULL,
  indexDate = "cohort_start_date",
  censorDate = NULL
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{strata}{List of variables to stratify results by. These variables
must be present in the cohort table.}

\item{indicationCohortName}{Name of the cohort table with potential
indications.}

\item{indicationCohortId}{The target cohort ID to add indication. If NULL all
cohorts will be considered.}

\item{indicationWindow}{The time window over which to identify indications.}

\item{unknownIndicationTable}{Tables in the OMOP CDM to search for unknown
indications.}

\item{indexDate}{A date variable in the cohort table for which indications
will be found relative to.}

\item{censorDate}{After that day no indication will be considered.}
}
\value{
A summarised result
}
\description{
Summarise the observed indications of patients in a drug cohort based on
their presence in an indication cohort in a specified time window. If an
individual is not in one of the indication cohorts, they will be considered
to have an unknown indication if they are present in one of the specified
OMOP CDM clinical tables. Otherwise, if they  are neither in an indication
cohort or a clinical table they will be considered as having no observed
indication.
}
\examples{
\donttest{
library(DrugUtilisation)
library(CDMConnector)
library(dplyr)

cdm <- mockDrugUtilisation()

indications <- list("headache" = 378253, "asthma" = 317009)
cdm <- generateConceptCohortSet(cdm, indications, "indication_cohorts")

cdm <- generateIngredientCohortSet(
  cdm = cdm, name = "drug_cohort",
  ingredient = "acetaminophen"
)

cdm$drug_cohort |>
  summariseIndication(
    indicationCohortName = "indication_cohorts",
    unknownIndicationTable = "condition_occurrence",
    indicationWindow = list(c(-Inf, 0))
  ) |>
  glimpse()
}

}
