% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{make_iivm_data}
\alias{make_iivm_data}
\title{Generates data from a interactive IV regression (IIVM) model.}
\usage{
make_iivm_data(
  n_obs = 500,
  dim_x = 20,
  theta = 1,
  alpha_x = 0.2,
  return_type = "DoubleMLData"
)
}
\arguments{
\item{n_obs}{(\code{integer(1)}) \cr
The number of observations to simulate.}

\item{dim_x}{(\code{integer(1)}) \cr
The number of covariates.}

\item{theta}{(\code{numeric(1)}) \cr
The value of the causal parameter.}

\item{alpha_x}{(\code{numeric(1)}) \cr
The value of the parameter \eqn{\alpha_x}.}

\item{return_type}{(\code{character(1)}) \cr
If \code{"DoubleMLData"}, returns a \code{DoubleMLData} object.
If \code{"data.frame"} returns a \code{data.frame()}.
If \code{"data.table"} returns a \code{data.table()}.
If \code{"matrix"} a named \code{list()} with entries \code{X}, \code{y}, \code{d} and \code{z}
is returned.
Every entry in the list is a \code{matrix()} object.  Default is \code{"DoubleMLData"}.}
}
\description{
Generates data from a interactive IV regression (IIVM) model.
The data generating process is defined as

\eqn{d_i = 1\left\lbrace \alpha_x Z + v_i > 0 \right\rbrace,}

\eqn{y_i = \theta d_i + x_i' \beta + u_i,}

\eqn{Z \sim \textstyle{Bernoulli} (0.5)} and

\eqn{\left(\begin{array}{c} u_i \\ v_i \end{array} \right) \sim
\mathcal{N}\left(0, \left(\begin{array}{cc} 1 & 0.3 \\ 0.3 & 1
\end{array} \right) \right).}

The covariates :\eqn{x_i \sim \mathcal{N}(0, \Sigma)}, where  \eqn{\Sigma}
is a matrix with entries
\eqn{\Sigma_{kj} = 0.5^{|j-k|}} and \eqn{\beta} is a \code{dim_x}-vector with
entries \eqn{\beta_j=\frac{1}{j^2}}.

The data generating process is inspired by a process used in the
simulation experiment of Farbmacher, Gruber and Klaaßen (2020).
}
\references{
Farbmacher, H., Guber, R. and Klaaßen, S. (2020).
Instrument Validity Tests with Causal Forests.
MEA Discussion Paper No. 13-2020.
Available at SSRN:\doi{10.2139/ssrn.3619201}.
}
