% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discreteBH_fun.R
\name{discrete.BH}
\alias{discrete.BH}
\alias{DBH}
\alias{ADBH}
\title{[HSU], [HSD], [AHSU] and [AHSD] procedures}
\usage{
discrete.BH(
  raw.pvalues,
  pCDFlist,
  alpha = 0.05,
  direction = "su",
  adaptive = FALSE,
  ret.crit.consts = FALSE
)

DBH(
  raw.pvalues,
  pCDFlist,
  alpha = 0.05,
  direction = "su",
  ret.crit.consts = FALSE
)

ADBH(
  raw.pvalues,
  pCDFlist,
  alpha = 0.05,
  direction = "su",
  ret.crit.consts = FALSE
)
}
\arguments{
\item{raw.pvalues}{vector of the raw observed p-values, as provided by the end user and before matching with their nearest neighbor in the CDFs supports.}

\item{pCDFlist}{a list of the supports of the CDFs of the p-values. Each support is represented by a vector that must be in increasing order.}

\item{alpha}{the target FDR level, a number strictly between 0 and 1.}

\item{direction}{a character string specifying whether to conduct a step-up (\code{direction="su"}, by default) or step-down procedure (\code{direction="sd"}).}

\item{adaptive}{a boolean specifying whether to conduct an adaptive procedure or not.}

\item{ret.crit.consts}{a boolean. If \code{TRUE}, critical constants are computed and returned (this is computationally intensive).}
}
\value{
A \code{DiscreteFDR} S3 class object whose elements are:
\item{Rejected}{Rejected raw p-values}
\item{Indices}{Indices of rejected hypotheses}
\item{Num.rejected}{Number of rejections}
\item{Adjusted}{Adjusted p-values (only for step-down direction).}
\item{Critical.constants}{Critical constants (if requested)}
\item{Method}{Character string describing the used algorithm, e.g. 'Discrete Benjamini-Hochberg procedure (step-up)'}
\item{Signif.level}{Significance level \code{alpha}}

\item{Data$raw.pvalues}{The values of \code{raw.pvalues}}
\item{Data$pCDFlist}{The values of \code{pCDFlist}}
\item{Data$data.name}{The respective variable names of \code{raw.pvalues} and \code{pCDFlist}}
}
\description{
Apply the [HSU], [HSD], [AHSU] and [AHSD] procedures, with or without
computing the critical constants, to a set of p-values and their discrete
support.
}
\details{
\code{DBH} and \code{ADBH} are wrapper functions for \code{discrete.BH}. \code{DBH} simply passes
all its parameters to \code{discrete.BH} with \code{adaptive = FALSE}. \code{ADBH} does the
same with \code{adaptive = TRUE}.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

#Construction of the p-values and their support
df.formatted <- fisher.pvalues.support(counts = df, input = "noassoc")
raw.pvalues <- df.formatted$raw
pCDFlist <- df.formatted$support
DBH.su.fast <- DBH(raw.pvalues, pCDFlist)
summary(DBH.su.fast)
DBH.sd.fast <- DBH(raw.pvalues, pCDFlist, direction = "sd")
DBH.sd.fast$Adjusted
summary(DBH.sd.fast)

DBH.su.crit <- DBH(raw.pvalues, pCDFlist, ret.crit.consts = TRUE)
summary(DBH.su.crit)
DBH.sd.crit <- DBH(raw.pvalues, pCDFlist, direction = "sd",
                   ret.crit.consts = TRUE)
DBH.sd.crit$Adjusted
summary(DBH.sd.crit)

ADBH.su.fast <- ADBH(raw.pvalues, pCDFlist)
summary(ADBH.su.fast)
ADBH.sd.fast <- ADBH(raw.pvalues, pCDFlist, direction = "sd")
ADBH.sd.fast$Adjusted
summary(ADBH.sd.fast)

ADBH.su.crit <- ADBH(raw.pvalues, pCDFlist, ret.crit.consts = TRUE)
summary(ADBH.su.crit)
ADBH.sd.crit <- ADBH(raw.pvalues, pCDFlist, direction = "sd",
                     ret.crit.consts = TRUE)
ADBH.sd.crit$Adjusted
summary(ADBH.sd.crit)

}
\references{
Döhler, S., Durand, G., & Roquain, E. (2018). New FDR bounds for discrete
and heterogeneous tests. \emph{Electronic Journal of Statistics}, \emph{12}(1),
pp. 1867-1900. \doi{10.1214/18-EJS1441}
}
\seealso{
\link{fast.Discrete}, \link{DBR}
}
