% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chowlin_likelihood.R
\name{chowlin_likelihood}
\alias{chowlin_likelihood}
\title{Likelihood function for Chow-Lin or Litterman temporal disaggregation.}
\usage{
chowlin_likelihood(Y, X, vcov)
}
\arguments{
\item{Y}{The low-frequency response series (an \eqn{n_l \times 1} matrix).}

\item{X}{The aggregated high-frequency indicator series (an \eqn{n_l \times p} matrix).}

\item{vcov}{Aggregated variance-covariance matrix for the Chow-Lin or Litterman residuals.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    The log-likelihood value for the given parameters.
}\if{html}{\out{</div>}}
}
\description{
This function computes the likelihood function used in temporal disaggregation to find the optimal \eqn{\rho} parameter.
It is used in conjunction with \code{\link{disaggregate}} to estimate the autocorrelation coefficient \eqn{\rho}.
}
\keyword{internal}
