% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{Vectorize.function}
\alias{Vectorize.function}
\title{Vectorize a multidimensional Function}
\usage{
Vectorize.function(
  fun,
  dim,
  .combine = rbind,
  .lapply = parallel::mclapply,
  ...
)
}
\arguments{
\item{fun}{'dim'-dimensional function to Vectorize}

\item{dim}{dimension of input arguments of fun}

\item{.combine}{how to combine results (default using c(.))}

\item{.lapply}{how to vectorize FUN call (default is parallel::mclapply)}

\item{...}{optional args to pass to 'Apply.function()', including .combine, .lapply, or optional args passed to 'fun'.}
}
\value{
a vectorized function (to be called on matrix argument, on each row)
}
\description{
Vectorize a d-dimensional (input) function, in the same way that base::Vectorize for 1-dimensional functions.
}
\examples{
f = function(x)x[1]+1; f(1:10); F = Vectorize.function(f,1);
F(1:10); #F = Vectorize(f); F(1:10);

f2 = function(x)x[1]+x[2]; f2(1:10); F2 = Vectorize.function(f2,2);
F2(cbind(1:10,11:20));

f3 = function(x)list(mean=x[1]+x[2],se=x[1]*x[2]); f3(1:10); F3 = Vectorize.function(f3,2);
F3(cbind(1:10,11:20));
}
