% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyn-methods.R
\name{make.DeponsDyn}
\alias{make.DeponsDyn}
\title{Make DeponsDyn object from data stored in data frame}
\usage{
make.DeponsDyn(
  oname,
  title = "NA",
  landscape = "NA",
  simtime = "NA",
  startday = "2000-01-01",
  timestep = 30,
  tz = "GMT"
)
}
\arguments{
\item{oname}{Name of the object (data frame) that contains number of
animals for each time step during the simulation, along with their energy and
the amount of food in the landscape.}

\item{title}{Optional character string giving name of simulation}

\item{landscape}{The landscape used in the simulation}

\item{simtime}{Optional character string with the date and time when the
simulation finished (format yyyy-mm-dd).}

\item{startday}{The start of the period that the  simulation represents, i.e.
the real-world equivalent of 'tick 1' (character string of the
form 'yyyy-mm-dd', or POSIXlt). Defaluts to 2000-01-01}

\item{timestep}{Time step used in the model, in minutes. Defaults to 30
minutes in DEPONS.}

\item{tz}{Time zone.}
}
\value{
\code{DeponsDyn} object containing simulation output
}
\description{
Function  for reading converting a data frame containing
DEPONS simulation output to a DeponsDyn object.
}
\examples{
data(porpoisedyn)
the.data <- as.data.frame(porpoisedyn)
the.data <- the.data[, c(1:4)]
names(the.data) <- c("tick", "PorpoiseCount", "FoodEnergyLevel", "PorpoiseEnergyLevel")
porpoisedyn2 <- make.DeponsDyn(the.data, startday="2010-01-01")
porpoisedyn2

}
\seealso{
See \code{\link{DeponsDyn-class}} for details on what is stored in
the output object.
}
