% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.fitLCmulti.R
\name{forecast.fitLCmulti}
\alias{forecast.fitLCmulti}
\title{Function to forecast multi-population mortality model}
\usage{
\method{forecast}{fitLCmulti}(object, nahead, ktmethod = c("Arimapdq", "arima010"), ...)
}
\arguments{
\item{object}{object \code{"fitLCmulti"} developed using function \code{fitLCmulti()}. With this object the function will determine the multi-population fitted with the function \code{fitLCmulti()}.}

\item{nahead}{number of periods ahead to forecast.}

\item{ktmethod}{method used to forecast the value of \code{kt} Arima(p,d,q) or ARIMA(0,1,0); c("\code{Arimapdq}", "\code{arima010}").}

\item{...}{other arguments for \code{\link[StMoMo:iarima]{iarima}}.}
}
\value{
A list with class \code{"forLCmulti"} including different components of the forecasting process:
\itemize{
\item \code{ax} parameter that captures the average shape of the mortality curve in all considered populations.
\item \code{bx} parameter that explains the age effect x with respect to the general trend \code{kt} in the mortality rates of all considered populations.
\item \code{arimakt} the arima selected for the \code{kt} time series.
\item \code{kt.fitted} obtained values for the tendency behavior captured by \code{kt}.
\item \code{kt.fut} projected values of \code{kt} for the nahead periods ahead.
\item \code{kt.futintervals} arima selected and future values of \code{kt} with the different intervals, lower and upper, 80\\% and 90\\%.
\item \code{Ii} parameter that captures the differences in the pattern of mortality in any region i with respect to Region 1.
\item \code{ktmethod} method selected to forecast the value of \code{kt} Arima(p,d,q) or ARIMA(0,1,0); c("\code{Arimapdq}", "\code{arima010}").
\item \code{formula} additive multi-population mortality formula used to fit the mortality rates.
\item \code{model} provided the model selected in every case.
\item \code{qxt.crude} corresponds to the crude mortality rates. These crude rate are directly obtained by dividing the number of registered deaths by the number of those initially exposed to the risk for age x, period t and in each region i.
\item \code{qxt.fitted} fitted mortality rates using the additive multi-population mortality model.
\item \code{logit.qxt.fitted} fitted mortality rates in logit way estimated with the additive multi-population mortality model.
\item \code{qxt.future} future mortality rates estimated with the additive multi-population mortality model.
\item \code{logit.qxt.future} future mortality rates in logit way estimated with the additive multi-population mortality model.
\item \code{nPop} provided number of populations to fit the periods.
}
}
\description{
R function for forecasting additive, multiplicative, common-factor (CFM), augmented-common-factor (ACFM), or joint-k multi-population mortality model developed by: Debon et al. (2011), Russolillo et al. (2011), Carter and Lee (1992), LI and Lee (2005), and Carter and Lee (2011), respectively.
These models follow the structure of the well-known Lee-Carter model (Lee and Carter, 1992) but include different parameter(s) to capture the behavior of each population considered in different ways.
This parameter seeks to capture the individual behavior of every population considered.
In case, you want to understand in depth each model, please see Villegas et al. (2017).
It should be mentioned that this function is developed for fitting several populations.
However, in case you only consider one population, the function will fit the single population version of the Lee-Carter model, the classical one.
}
\examples{
#The example takes more than 5 seconds because it includes
#several fitting and forecasting process and hence all
#the process is included in donttest
\donttest{
#First, we present the data that we are going to use
SpainRegions
ages <- c(0, 1, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90)

library(gnm)
library(forecast)
#1. ADDITIVE MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the additive multi-population mortality model
additive_Spainmales <- fitLCmulti(model = "additive",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

additive_Spainmales

#If the user does not provide the model inside the function fitLCmult()
#the multi-population mortality model applied will be additive one.

#Once, we have fit the data, it is possible to see the ax, bx, kt, and Ii
#provided parameters for the fitting.
plot(additive_Spainmales)

#Once, we have fit the data, it is possible to forecast the multipopulation
#mortality model several years ahead, for example 10, as follows:
fut_additive_Spainmales <- forecast(object = additive_Spainmales, nahead = 10,
                                    ktmethod = "Arimapdq")

fut_additive_Spainmales
#Once the data have been adjusted, it is possible to display the fitted kt and
#its out-of-sample forecasting. In addition, the function shows
#the logit mortality adjusted in-sample and projected out-of-sample
#for the mean age of the data considered in all populations.
plot(fut_additive_Spainmales)

#2. MULTIPLICATIVE MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the multiplicative multi-population mortality model
multiplicative_Spainmales <- fitLCmulti(model = "multiplicative",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

multiplicative_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(multiplicative_Spainmales)

#Once, we have fit the data, it is possible to forecast the multipopulation
#mortality model several years ahead, for example 10, as follows:
fut_multi_Spainmales <- forecast(object = multiplicative_Spainmales, nahead = 10,
                                 ktmethod = "Arimapdq")

fut_multi_Spainmales
#Once the data have been adjusted, it is possible to display the fitted kt and
#its out-of-sample forecasting. In addition, the function shows
#the logit mortality adjusted in-sample and projected out-of-sample
#for the mean age of the data considered in all populations.
plot(fut_multi_Spainmales)

#3. COMMON-FACTOR MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the common-factor multi-population mortality model
cfm_Spainmales <- fitLCmulti(model = "CFM",
                             qxt = SpainRegions$qx_male,
                             periods = c(1991:2020),
                             ages = c(ages),
                             nPop = 18,
                             lxt = SpainRegions$lx_male)

cfm_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(cfm_Spainmales)

#Once, we have fit the data, it is possible to forecast the multipopulation
#mortality model several years ahead, for example 10, as follows:
fut_cfm_Spainmales <- forecast(object = cfm_Spainmales, nahead = 10,
                               ktmethod = "Arimapdq")

fut_cfm_Spainmales
#Once the data have been adjusted, it is possible to display the fitted kt and
#its out-of-sample forecasting. In addition, the function shows
#the logit mortality adjusted in-sample and projected out-of-sample
#for the mean age of the data considered in all populations.
plot(fut_cfm_Spainmales)

#4. JOINT-K MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the joint-K multi-population mortality model
jointk_Spainmales <- fitLCmulti(model = "joint-K",
                                qxt = SpainRegions$qx_male,
                                periods = c(1991:2020),
                                ages = c(ages),
                                nPop = 18,
                                lxt = SpainRegions$lx_male)

jointk_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(jointk_Spainmales)

#Once, we have fit the data, it is possible to forecast the multipopulation
#mortality model several years ahead, for example 10, as follows:
fut_jointk_Spainmales <- forecast(object = jointk_Spainmales, nahead = 10,
                               ktmethod = "Arimapdq")

fut_jointk_Spainmales
#Once the data have been adjusted, it is possible to display the fitted kt and
#its out-of-sample forecasting. In addition, the function shows
#the logit mortality adjusted in-sample and projected out-of-sample
#for the mean age of the data considered in all populations.
plot(fut_jointk_Spainmales)

#5. AUGMENTED-COMMON-FACTOR MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the augmented-common-factor multi-population mortality model
acfm_Spainmales <- fitLCmulti(model = "ACFM",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

acfm_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(acfm_Spainmales)

#Once, we have fit the data, it is possible to forecast the multipopulation
#mortality model several years ahead, for example 10, as follows:
fut_acfm_Spainmales <- forecast(object = acfm_Spainmales, nahead = 10,
                               ktmethod = "Arimapdq")

fut_acfm_Spainmales
#Once the data have been adjusted, it is possible to display the fitted kt and
#its out-of-sample forecasting. In addition, the function shows
#the logit mortality adjusted in-sample and projected out-of-sample
#for the mean age of the data considered in all populations.
plot(fut_acfm_Spainmales)

#6. LEE-CARTER FOR SINGLE-POPULATION
#As we mentioned in the details of the function, if we only provide the data
#from one-population the function fitLCmulti()
#will fit the Lee-Carter model for single populations.
LC_Spainmales <- fitLCmulti(qxt = SpainNat$qx_male,
                              periods = c(1991:2020),
                              ages = ages,
                              model = "additive",
                              nPop = 1)

LC_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, and kt
#parameters provided for the single version of the LC.
plot(LC_Spainmales)

#Once, we have fit the data, it is possible to forecast the multipopulation
#mortality model several years ahead, for example 10, as follows:
fut_LC_Spainmales <- forecast(object = LC_Spainmales, nahead = 10,
                              ktmethod = "Arimapdq")

#Once the data have been adjusted, it is possible to display the fitted kt and
#its out-of-sample forecasting. In addition, the function shows
#the logit mortality adjusted in-sample and projected out-of-sample
#for the mean age of the data considered in all populations.
plot(fut_LC_Spainmales)

}

}
\references{
Carter, L.R. and Lee, R.D. (1992).
Modeling and forecasting US sex differentials in mortality.
International Journal of Forecasting, 8(3), 393–411.

Debon, A., Montes, F., & Martinez-Ruiz, F. (2011).
Statistical methods to compare mortality for a group with non-divergent populations: an application to Spanish regions.
European Actuarial Journal, 1, 291-308.

Lee, R.D. & Carter, L.R. (1992).
Modeling and forecasting US mortality.
Journal of the American Statistical Association, 87(419), 659–671.

Li, N. and Lee, R.D. (2005).
Coherent mortality forecasts for a group of populations: An extension of the Lee-Carter method.
Demography, 42(3), 575–594.

Russolillo, M., Giordano, G., & Haberman, S. (2011).
Extending the Lee–Carter model: a three-way decomposition.
Scandinavian Actuarial Journal, 2011(2), 96-117.

Villegas, A. M., Haberman, S., Kaishev, V. K., & Millossovich, P. (2017).
A comparative study of two-population models for the assessment of basis risk in longevity hedges.
ASTIN Bulletin, 47(3), 631-679.
}
\seealso{
\code{\link{fitLCmulti}},
\code{\link{plot.fitLCmulti}}, \code{\link{plot.forLCmulti}},
\code{\link{multipopulation_cv}}, \link[StMoMo:iarima]{iarima}
}
