% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{getTestKM.list}
\alias{getTestKM.list}
\title{getTestKM.list}
\usage{
getTestKM.list(
  lst_models,
  X_test,
  Y_test,
  lst_cutoff,
  type = "LP",
  ori_data = TRUE,
  BREAKTIME = NULL,
  n.breaks = 20,
  title = NULL,
  verbose = FALSE
)
}
\arguments{
\item{lst_models}{List of Coxmos model}

\item{X_test}{Numeric matrix or data.frame. Explanatory variables for test data (raw format).
Qualitative variables must be transform into binary variables.}

\item{Y_test}{Numeric matrix or data.frame. Response variables for test data. Object must have
two columns named as "time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE
for censored and event observations.}

\item{lst_cutoff}{Numeric vector. Cutoff vector to split the observations into two groups for each
model. Recommended to compute optimal cutoff value with getAutoKM() or getAutoKM.list() functions.}

\item{type}{Character. Kaplan Meier for complete model linear predictor ("LP"), for PLS components
("COMP") or for original variables ("VAR") (default: LP).}

\item{ori_data}{Logical. Compute the Kaplan-Meier plot with the raw-data or the normalize-data to
compute the best cut-point for splitting the data into two groups. Only used when type = "VAR"
(default: TRUE).}

\item{BREAKTIME}{Numeric. Size of time to split the data into "total_time / BREAKTIME + 1" points.
If BREAKTIME = NULL, "n.breaks" is used (default: NULL).}

\item{n.breaks}{Numeric. If BREAKTIME is NULL, "n.breaks" is the number of time-break points to
compute (default: 20).}

\item{title}{Character. Kaplan-Meier plot title (default: NULL).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
A list where each element corresponds to a Kaplan-Meier plot generated for each model in
the input list. Each plot visualizes the survival probabilities based on the specified cutoff
values for the respective model. The list's names correspond to the names of the models provided
in the input list.
}
\description{
Run the function "getTestKM" for a list of models. More information in "?getTestKM".
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X_proteomic <- X_proteomic[1:30,1:15]
Y_proteomic <- Y_proteomic[1:30,]
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,]
Y_train <- Y_proteomic[index_train,]
X_test <- X_proteomic[-index_train,]
Y_test <- Y_proteomic[-index_train,]
splsicox.model <- splsicox(X_train, Y_train, n.comp = 1, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
splsdrcox.model <- splsdrcox_penalty(X_train, Y_train, n.comp = 1, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
lst_models = list("sPLSICOX" = splsicox.model, "sPLSDRCOX" = splsdrcox.model)
lst_results = getAutoKM.list(type = "LP", lst_models)
lst_cutoff <- getCutoffAutoKM.list(lst_results)
getTestKM.list(lst_models, X_test, Y_test, lst_cutoff)
}
\references{
\insertRef{Kaplan_1958}{Coxmos}
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
