% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RiskParityPortfolio.R
\name{RiskParityPortfolio}
\alias{RiskParityPortfolio}
\title{Minimum connectedness portfolio}
\usage{
RiskParityPortfolio(
  x,
  H,
  method = c("cumsum", "cumprod"),
  statistics = c("Fisher", "Bartlett", "Fligner-Killeen", "Levene", "Brown-Forsythe"),
  long = TRUE,
  digit = 2
)
}
\arguments{
\item{x}{zoo return matrix (in percentage)}

\item{H}{Pairwise connectedness matrix or alternatively variance-covariance or correlation matrix}

\item{method}{Cumulative sum or cumulative product}

\item{statistics}{Hedging effectiveness statistic}

\item{long}{Allow only long portfolio position}

\item{digit}{Number of decimal places}
}
\value{
Get portfolio weights
}
\description{
This function calculates the minimum connectedness portfolio
}
\examples{
data("g2020")
fit = VAR(g2020, configuration=list(nlag=1))
mcp = RiskParityPortfolio(g2020, fit$Q, statistics="Fisher")
mcp$TABLE
}
\references{
Ederington, L. H. (1979). The hedging performance of the new futures markets. The Journal of Finance, 34(1), 157-170.

Antonakakis, N., Cunado, J., Filis, G., Gabauer, D., & de Gracia, F. P. (2020). Oil and asset classes implied volatilities: Investment strategies and hedging effectiveness. Energy Economics, 91, 104762.
}
\author{
David Gabauer
}
