% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JointConnectedness.R
\name{JointConnectedness}
\alias{JointConnectedness}
\title{Lastrapes and Wiesen (2021) joint connectedness approach}
\usage{
JointConnectedness(Phi, Sigma, nfore)
}
\arguments{
\item{Phi}{VAR coefficient matrix}

\item{Sigma}{Residual variance-covariance matrix}

\item{nfore}{H-step ahead forecast horizon}
}
\value{
Get connectedness measures
}
\description{
This function calculates the Lastrapes and Wiesen (2021) joint connectedness measures.
}
\examples{
\donttest{
data(lw2021)
fit = VAR(lw2021, configuration=list(nlag=2))
dca = JointConnectedness(Phi=fit$B, Sigma=fit$Q, nfore=30)
dca$TABLE
}
}
\references{
Lastrapes, W. D., & Wiesen, T. F. (2021). The joint spillover index. Economic Modelling, 94, 681-691.
}
\author{
David Gabauer
}
