% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectednessApproach.R
\name{ConnectednessApproach}
\alias{ConnectednessApproach}
\title{Connectedness Approach}
\usage{
ConnectednessApproach(
  x,
  nlag = 1,
  nfore = 10,
  window.size = NULL,
  corrected = FALSE,
  model = c("VAR", "QVAR", "LASSO", "Ridge", "Elastic", "TVP-VAR", "DCC-GARCH"),
  connectedness = c("Time", "Frequency", "Joint", "Extended Joint"),
  VAR_config = list(QVAR = list(tau = 0.5), ElasticNet = list(nfolds = 10, alpha =
    NULL, loss = "mae", delta_alpha = 0.1), TVPVAR = list(kappa1 = 0.99, kappa2 = 0.99,
    prior = "BayesPrior", gamma = 0.01)),
  DCC_config = list(standardize = FALSE),
  Connectedness_config = list(TimeConnectedness = list(generalized = TRUE),
    FrequencyConnectedness = list(partition = c(pi, pi/2, 0), generalized = TRUE,
    scenario = "ABS"))
)
}
\arguments{
\item{x}{zoo data matrix}

\item{nlag}{Lag length}

\item{nfore}{H-step ahead forecast horizon}

\item{window.size}{Rolling-window size or Bayes Prior sample size}

\item{corrected}{Boolean value whether corrected or standard TCI should be computed}

\item{model}{Estimation model}

\item{connectedness}{Type of connectedness approach}

\item{VAR_config}{Config for VAR model}

\item{DCC_config}{Config for DCC-GARCH model}

\item{Connectedness_config}{Config for connectedness approach}
}
\value{
Get connectedness measures
}
\description{
This function provides a modular framework combining various models and connectedness frameworks.
}
\examples{
\donttest{
data("acg2020")
dca = ConnectednessApproach(acg2020, 
                            nlag=1, 
                            nfore=12,
                            model="TVP-VAR",
                            connectedness="Time",
                            VAR_config=list(TVPVAR=list(kappa1=0.99, kappa2=0.96,
                                            prior="MinnesotaPrior", gamma=0.1)))
dca$TABLE
}
}
\references{
Diebold, F. X., & Yilmaz, K. (2009). Measuring financial asset return and volatility spillovers, with application to global equity markets. The Economic Journal, 119(534), 158-171.

Diebold, F. X., & Yilmaz, K. (2012). Better to give than to receive: Predictive directional measurement of volatility spillovers. International Journal of Forecasting, 28(1), 57-66.

Barunik, J., & Krehlik, T. (2018). Measuring the frequency dynamics of financial connectedness and systemic risk. Journal of Financial Econometrics, 16(2), 271-296.

Gabauer, D. (2020). Volatility impulse response analysis for DCC-GARCH models: The role of volatility transmission mechanisms. Journal of Forecasting, 39(5), 788-796.

Antonakakis, N., Chatziantoniou, I., & Gabauer, D. (2020). Refined measures of dynamic connectedness based on time-varying parameter vector autoregressions. Journal of Risk and Financial Management, 13(4), 84.

Lastrapes, W. D., & Wiesen, T. F. (2021). The joint spillover index. Economic Modelling, 94, 681-691.

Balcilar, M., Gabauer, D., & Umar, Z. (2021). Crude Oil futures contracts and commodity markets: New evidence from a TVP-VAR extended joint connectedness approach. Resources Policy, 73, 102219.

Chatziantoniou, I., & Gabauer, D. (2021). EMU risk-synchronisation and financial fragility through the prism of dynamic connectedness. The Quarterly Review of Economics and Finance, 79, 1-14.

Chatziantoniou, I., Gabauer, D., & Stenfors, A. (2021). Interest rate swaps and the transmission mechanism of monetary policy: A quantile connectedness approach. Economics Letters, 204, 109891.

Gabauer, D. (2021). Dynamic measures of asymmetric & pairwise connectedness within an optimal currency area: Evidence from the ERM I system. Journal of Multinational Financial Management, 60, 100680.

Gabauer, D., Gupta, R., Marfatia, H., & Miller, S. (2020). Estimating US Housing Price Network Connectedness: Evidence from Dynamic Elastic Net, Lasso, and Ridge Vector Autoregressive Models (No. 202065). University of Pretoria, Department of Economics.

Chatziantoniou, I., Gabauer, D., & Gupta, R. (2021). Integration and Risk Transmission in the Market for Crude Oil: A Time-Varying Parameter Frequency Connectedness Approach (No. 202147).

Chatziantoniou, I., Aikins Abakah, E. J., Gabauer, D., & Tiwari, A. K. (2022). Quantile time-frequency price connectedness between green bond, green equity, sustainable investments and clean energy markets. Journal of Cleaner Production.

Cunado, J, Chatziantoniou, I., Gabauer, D., Hardik, M., & de Garcia, F.P. (2022). Dynamic spillovers across precious metals and energy realized volatilities: Evidence from quantile extended joint connectedness measures.
}
\author{
David Gabauer
}
