% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeDDL.R
\name{writeDdl}
\alias{writeDdl}
\alias{writePrimaryKeys}
\alias{writeForeignKeys}
\alias{writeIndex}
\title{Write DDL script}
\usage{
writeDdl(
  targetDialect,
  cdmVersion,
  outputfolder,
  cdmDatabaseSchema = "@cdmDatabaseSchema"
)

writePrimaryKeys(
  targetDialect,
  cdmVersion,
  outputfolder,
  cdmDatabaseSchema = "@cdmDatabaseSchema"
)

writeForeignKeys(
  targetDialect,
  cdmVersion,
  outputfolder,
  cdmDatabaseSchema = "@cdmDatabaseSchema"
)

writeIndex(
  targetDialect,
  cdmVersion,
  outputfolder,
  cdmDatabaseSchema = "@cdmDatabaseSchema"
)
}
\arguments{
\item{targetDialect}{The dialect of the target database. Support dialects are specified by SqlRender::listSupportedDialects}

\item{cdmVersion}{The version of the CDM you are creating, e.g. 5.3, 5.4}

\item{outputfolder}{The directory or folder where the SQL file should be saved.}

\item{cdmDatabaseSchema}{The schema of the CDM instance where the DDL will be run. For example, this would be "ohdsi.dbo" when testing on sql server.
Defaults to "@cdmDatabaseSchema"}
}
\value{
Writes SQL file with the OMOP CDM DDL for the specified CDM version and target dialect in the output folder.

Writes a SQL file with the primary keys for the OMOP CDM based on the specified target dialect and CDM version.

Writes a SQL file with the foreign keys for the OMOP CDM based on the specified target dialect and CDM version.

Writes a SQL file with the indices for the OMOP CDM based on the specified target dialect and CDM version.
}
\description{
Write the DDL to a SQL file. The SQL will be rendered (parameters replaced) and translated to the target SQL
dialect. By default the @cdmDatabaseSchema parameter is kept in the SQL file and needs to be replaced before
execution.
}
\section{Functions}{
\itemize{
\item \code{writePrimaryKeys()}: writePrimaryKeys Write the SQL code that creates the primary keys to a file.

\item \code{writeForeignKeys()}: writeForeignKeys Write the SQL code that creates the foreign keys to a file.

\item \code{writeIndex()}: writeIndex Write the rendered and translated sql that creates recommended indexes to a file.

}}
