% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comfam_shiny.R
\name{combat_table_gen}
\alias{combat_table_gen}
\title{Generate Diagnostic Tables for Batch Effect Analysis}
\usage{
combat_table_gen(
  result,
  table_name,
  f = NULL,
  c = NULL,
  PC1 = NULL,
  PC2 = NULL
)
}
\arguments{
\item{result}{A list derived from \code{visual_prep()} that contains datasets and statistical test results for Shiny visualization.}

\item{table_name}{A string specifying the type of table to generate. Options include:
\itemize{
\item \code{"data_overview"}: Overview of the dataset, including covariates, features, and batch information.
\item \code{"exploratory_analysis"}: Summary of the selected feature and covariates.
\item \code{"summary_df"}: Summary of batch-level distributions, including batch removal status.
\item \code{"cov_table"}: Covariate summary table, displaying distributions for numeric or categorical covariates.
\item \code{"pc_variance"}: Variance explained by specified principal components.
\item \code{"mdmr"}: Results from the Multivariate Distance Matrix Regression (MDMR) analysis.
\item \code{"kenward_roger"}: Results from Kenward-Roger tests.
\item \code{"anova"}: Results from ANOVA tests.
\item \code{"kruskal_wallis"}: Results from Kruskal-Wallis tests.
\item \code{"fligner_killeen"}: Results from Fligner-Killeen tests.
\item \code{"levenes"}: Results from Levene's tests.
\item \code{"bartletts"}: Results from Bartlett's tests.
}}

\item{f}{A string specifying the feature of interest for tables requiring a specific feature. Default is \code{NULL}.}

\item{c}{A string specifying the covariate of interest for tables requiring a specific covariate. Default is \code{NULL}.}

\item{PC1}{A string specifying the first principal component for PCA variance tables. Default is \code{NULL}.}

\item{PC2}{A string specifying the second principal component for PCA variance tables. Default is \code{NULL}.}
}
\value{
A \code{DT::datatable} object containing the requested table.
}
\description{
This function generates a variety of tables to summarize data and results from batch effect analyses.
Depending on the specified table name, it can create data overview tables, exploratory analysis summaries,
statistical test results, PCA summaries, and covariate distributions.
}
\details{
The function dynamically generates tables based on the \code{table_name} parameter.
}
\examples{
if(interactive()){
 result <- visual_prep(type = "lm", features = "thickness.left.cuneus",
 batch = "manufac", covariates = "AGE", df = adni[1:100, ], mdmr = FALSE, cores = 1)
 combat_table_gen(result, table_name = "cov_table", c = "AGE")
 combat_table_gen(result, table_name = "pc_variance", PC1 = "PC1", PC2 = "PC2")
 }

}
