% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comfam_shiny.R
\name{combat_plot_gen}
\alias{combat_plot_gen}
\title{Generate Diagnostic Plots for Batch Effect Analysis}
\usage{
combat_plot_gen(
  result,
  f = NULL,
  batch_control = "No",
  batch_level = NULL,
  plot_name,
  c = NULL,
  smooth_method = "lm",
  alpha = 0.2,
  char_plot_type = "boxplot",
  text_status = "No",
  color = "No",
  label = "No",
  angle = 0,
  PC1 = NULL,
  PC2 = NULL,
  eb = TRUE,
  eb_df = NULL
)
}
\arguments{
\item{result}{A list derived from \code{visual_prep()} that contains datasets and statistical test results for Shiny visualization.}

\item{f}{A string specifying the feature of interest for visualization.}

\item{batch_control}{A string indicating whether to include batch-specific controls. Defaults to \code{"No"}.}

\item{batch_level}{A vector specifying the batch levels to include in the plot. Used only when \code{batch_control} is not \code{"No"}.}

\item{plot_name}{A string specifying the type of plot to generate. Options include \code{"batch_density"}, \code{"cov_feature"}, \code{"batch_summary"}, \code{"cov_distribution"}, \code{"resid_add"}, \code{"resid_mul"}, \code{"pca"}, \code{"tsne"}, \code{"eb_location"}, and \code{"eb_scale"}.}

\item{c}{A string specifying the covariate of interest for \code{"cov_feature"} or \code{"cov_distribution"} plots.}

\item{smooth_method}{A string specifying the smoothing method for trend lines. Defaults to \code{"lm"} (linear model).}

\item{alpha}{A numeric value between 0 and 1 controlling the transparency of trend lines. Defaults to \code{0.2}.}

\item{char_plot_type}{A string specifying the type of plot for categorical covariates. Options include \code{"boxplot"}, \code{"boxplot with points"}, and \code{"density plot"}. Defaults to \code{"boxplot"}.}

\item{text_status}{A string indicating whether to display text annotations in the plot. Defaults to \code{"No"}.}

\item{color}{A string indicating whether to use color coding in plots. Defaults to \code{"No"}.}

\item{label}{A string indicating whether to include axis labels in the plot. Defaults to \code{"No"}.}

\item{angle}{A numeric value specifying the angle of x-axis labels. Defaults to \code{0}.}

\item{PC1}{A string specifying the first principal component for PCA plots.}

\item{PC2}{A string specifying the second principal component for PCA plots.}

\item{eb}{A logical value indicating whether to include empirical Bayes prior information in the plot. Defaults to \code{TRUE}.}

\item{eb_df}{A data frame containing empirical Bayes information for generating \code{eb_location} and \code{eb_scale} plots.}
}
\value{
A ggplot object representing the specified diagnostic plot.
}
\description{
This function generates a variety of diagnostic plots for analyzing batch effects and their relationships with features and covariates.
Depending on the specified plot type, it can create density plots, box plots, residual plots, PCA plots, T-SNE plots, and empirical Bayes diagnostic plots.
}
\details{
The function dynamically generates plots based on the \code{plot_name} parameter:
\itemize{
\item \code{"batch_density"}: Density plots of features by batch levels.
\item \code{"cov_feature"}: Covariate vs. feature plots with optional batch adjustments.
\item \code{"batch_summary"}: Bar plots summarizing batch-level distributions.
\item \code{"cov_distribution"}: Covariate distributions stratified by batch.
\item \code{"resid_add"}: Additive residual box plots.
\item \code{"resid_mul"}: Multiplicative residual box plots.
\item \code{"pca"}: Principal Component Analysis (PCA) plots.
\item \code{"tsne"}: T-SNE plots for dimensionality reduction.
\item \code{"eb_location"}: Empirical Bayes location parameter density plots.
\item \code{"eb_scale"}: Empirical Bayes scale parameter density plots.
}
}
\examples{
if(interactive()){
 result <- visual_prep(type = "lm", features = "thickness.left.cuneus",
 batch = "manufac", covariates = "AGE", df = adni[1:100, ], mdmr = FALSE, cores = 1)
 combat_plot_gen(result, f = "thickness.left.cuneus", plot_name = "batch_density")
 combat_plot_gen(result, f = "thickness.left.cuneus", c = "AGE", plot_name = "cov_feature")
}

}
