% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divipola.R
\name{name_to_standard_dep}
\alias{name_to_standard_dep}
\title{Translate department names to  official departments' DIVIPOLA names}
\usage{
name_to_standard_dep(department_name)
}
\arguments{
\item{department_name}{character vector with the names to be translated.}
}
\value{
character vector with the DIVIPOLA name of the departments.
}
\description{
Department names are usually manually input, which leads to multiple errors
and lack of standardization. This functions translates department names to
their respective official names from DIVIPOLA.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dptos <- c("Bogota DC", "San Andres")
name_to_standard_dep(dptos)
\dontshow{\}) # examplesIf}
}
