% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Export.R
\name{exportCohortStatsTables}
\alias{exportCohortStatsTables}
\title{Export the cohort statistics tables to the file system}
\usage{
exportCohortStatsTables(
  connectionDetails,
  connection = NULL,
  cohortDatabaseSchema,
  cohortTableNames = getCohortTableNames(),
  cohortStatisticsFolder,
  snakeCaseToCamelCase = TRUE,
  fileNamesInSnakeCase = FALSE,
  incremental = FALSE,
  databaseId = NULL,
  minCellCount = 5,
  cohortDefinitionSet = NULL,
  tablePrefix = ""
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTableNames}{The names of the cohort tables. See \code{\link{getCohortTableNames}}
for more details.}

\item{cohortStatisticsFolder}{The path to the folder where the cohort statistics folder
where the results will be written}

\item{snakeCaseToCamelCase}{Should column names in the exported files
convert from snake_case to camelCase? Default is FALSE}

\item{fileNamesInSnakeCase}{Should the exported files use snake_case? Default is FALSE}

\item{incremental}{If \code{incremental = TRUE}, results are written to update values instead of
overwriting an existing results}

\item{databaseId}{Optional - when specified, the databaseId will be added
to the exported results}

\item{minCellCount}{To preserve privacy: the minimum number of subjects contributing
to a count before it can be included in the results. If the
count is below this threshold, it will be set to `-minCellCount`.}

\item{cohortDefinitionSet}{The \code{cohortDefinitionSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{sql}{The OHDSI-SQL used to generate the cohort}}
Optionally, this data frame may contain: \describe{
\item{json}{The Circe JSON representation of the cohort}}}

\item{tablePrefix}{Optional - allows to append a prefix to the exported
file names.}
}
\description{
This function retrieves the data from the cohort statistics tables and
writes them to the inclusion statistics folder specified in the function
call. NOTE: inclusion rule names are handled in one of two ways:

1. You can specify the cohortDefinitionSet parameter and the inclusion rule
names will be extracted from the data.frame.
2. You can insert the inclusion rule names into the database using the
insertInclusionRuleNames function of this package.

The first approach is preferred as to avoid the warning emitted.
}
