% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographicsCohort.R
\name{demographicsCohort}
\alias{demographicsCohort}
\title{Create cohorts based on patient demographics}
\usage{
demographicsCohort(
  cdm,
  name,
  ageRange = NULL,
  sex = NULL,
  minPriorObservation = NULL,
  minFutureObservation = NULL
)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{name}{Name of the new cohort table}

\item{ageRange}{A list of vectors specifying minimum and maximum age.}

\item{sex}{Can be "Both", "Male" or "Female".}

\item{minPriorObservation}{A minimum number of prior observation days in
the database.}

\item{minFutureObservation}{A minimum number of future observation days in
the database.}
}
\value{
A cohort table
}
\description{
Create cohorts based on patient demographics
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor()

cohort <-  cdm |> demographicsCohort(name = "cohort3", ageRange = c(18,40), sex = "Male")

attrition(cohort)
}
}
