% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCodeUse.R
\name{summariseCodeUse}
\alias{summariseCodeUse}
\title{Summarise code use in patient-level data}
\usage{
summariseCodeUse(
  x,
  cdm,
  countBy = c("record", "person"),
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL
)
}
\arguments{
\item{x}{List of concept IDs}

\item{cdm}{cdm_reference via CDMConnector::cdm_from_con()}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by
concept}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}
}
\value{
A tibble with results overall and, if specified, by strata
}
\description{
Summarise code use in patient-level data
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(),
                      dbdir = CDMConnector::eunomia_dir())
cdm <- CDMConnector::cdm_from_con(con,
                                  cdm_schem = "main",
                                  write_schema = "main")
acetiminophen <- c(1125315,  1127433, 40229134,
40231925, 40162522, 19133768,  1127078)
poliovirus_vaccine <- c(40213160)
cs <- list(acetiminophen = acetiminophen,
          poliovirus_vaccine = poliovirus_vaccine)
results <- summariseCodeUse(cs,cdm = cdm)
results
CDMConnector::cdmDisconnect(cdm)
}

}
