% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_Functions.R
\name{ClickClust_EM}
\alias{ClickClust_EM}
\title{EM Algorithm for Continuous Time Markov Models}
\usage{
ClickClust_EM(x, t, J, G, itemEM = 5, starts = 100, maxit = 5000,
  tol = 0.001, Contin = TRUE, Verbose = TRUE, seed = 1,
  known = NULL, crit = "BIC", returnall = FALSE)
}
\arguments{
\item{x}{A list of states}

\item{t}{A list of times spent in each state}

\item{J}{The total number of states}

\item{G}{A vector containing the number of groups to test}

\item{itemEM}{The number of emEM iterations for initialization (defaults to 5)}

\item{starts}{The number of random starting values for the emEM algorithm (defaults to 100)}

\item{maxit}{The maximum number of iterations after initialization (defaults to 5000)}

\item{tol}{The tolerance for convergence (defaults to 0.001)}

\item{Contin}{Fit the continuous time model (defaults to TRUE). If FALSE, fit the discrete model.}

\item{Verbose}{Display Messages (defaults to TRUE)}

\item{seed}{Sets the seed for the emEM algorithm (defaults to 1)}

\item{known}{A vector of labels for semi-supervised classification. 0 indicates unknown observations. The known labels are denoted by their group number (1,2,3, etc.).}

\item{crit}{The model selection criterion to use ("BIC" or "ICL"). Defaults to "BIC".}

\item{returnall}{If true, returns the results for all groups considered. Defaults to FALSE.}
}
\value{
Returns a list with parameter and classification estimates for the best model chosen by the selection criterion.
}
\description{
This function fits the continuous time first order markov model for a specified set of groups and returns the model chosen by the BIC.
}
\examples{
library(gtools)
data(SimData)
x<-SimData[[1]]
t<-SimData[[2]]
Click_2G<-ClickClust_EM(x=x,t=t,J=5,G=2,starts=10)
}
