% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_regression.R
\name{outcome_regression}
\alias{outcome_regression}
\title{Outcome Regression}
\usage{
outcome_regression(
  data,
  f = NA,
  simple = pkg.env$simple,
  family = gaussian(),
  contrasts = list(),
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables in the model.
This should be the same data used in \code{\link[=init_params]{init_params}}.}

\item{f}{(optional) an object of class "formula" that overrides the default parameter}

\item{simple}{a boolean indicator to build default formula with interactions.
If true, interactions will be excluded. If false, interactions will be included. By
default, simple is set to false.}

\item{family}{the family to be used in the general linear model.
By default, this is set to \code{\link[stats:gaussian]{gaussian}}.
NOTE: if this is changed, the assumptions about the model output may be incorrect and may not provide
accurate treatment effects.}

\item{contrasts}{a list of continuous covariates and values in the model to be included in the contrast matrix
(e.g. \code{list(age = c(18, 25, 40), weight = c(90, 159))}).}

\item{...}{additional arguments that may be passed to the underlying \code{\link[multcomp:glht]{glht}} model.}
}
\value{
\code{outcome_regression} returns an object of \code{\link[base:class]{class} "outcome_regression"}

The functions \code{print}, \code{summary}, and \code{predict} can be used to interact with
the underlying \code{glht} model.

An object of class \code{"outcome_regression"} is a list containing the following:

 \item{call}{the matched call.}
 \item{formula}{the formula used in the model.}
 \item{model}{the underlying glht model.}
 \item{ATE}{a data frame containing the ATE, SE, and 95\% CI of the ATE. }
 \item{ATE.summary}{a more detailed summary of the ATE estimations from glht. }
}
\description{
`outcome_regression` builds a linear model using all covariates. The treatment effects are stratified
within the levels of the covariates. The model will automatically provide all discrete covariates in a contrast matrix.
To view estimated change in treatment effect from continuous variables, a list called \code{contrasts}, needs to be given
with specific values to estimate. A vector of values can be given for any particular continuous variable.
}
\examples{
library(causaldata)
library(multcomp)

data(nhefs)
nhefs.nmv <- nhefs[which(!is.na(nhefs$wt82)), ]
nhefs.nmv$qsmk <- as.factor(nhefs.nmv$qsmk)

confounders <- c(
  "sex", "race", "age", "education", "smokeintensity",
  "smokeyrs", "exercise", "active", "wt71"
)

init_params(wt82_71, qsmk,
  covariates = confounders,
  data = nhefs.nmv
)

out.mod <- outcome_regression(nhefs.nmv, contrasts = list(
  age = c(21, 55),
  smokeintensity = c(5, 20, 40)
))
print(out.mod)
summary(out.mod)
head(data.frame(preds = predict(out.mod)))

}
