% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perfect_sensitivity_EM.R
\name{perfect_sensitivity_EM}
\alias{perfect_sensitivity_EM}
\title{EM-Algorithm Estimation of the Binary Outcome Misclassification Model while Assuming Perfect Sensitivity}
\usage{
perfect_sensitivity_EM(
  Ystar,
  Z,
  X,
  start,
  beta0_fixed = NULL,
  weights = NULL,
  expected = TRUE,
  tolerance = 1e-07,
  max_em_iterations = 1500
)
}
\arguments{
\item{Ystar}{A numeric vector of indicator variables (1, 0) for the observed
outcome \code{Y*}. The reference category is 0.}

\item{Z}{A numeric matrix of covariates in the true outcome mechanism.
\code{Z} should not contain an intercept.}

\item{X}{A numeric matrix of covariates in the observation mechanism.
\code{X} should not contain an intercept.}

\item{start}{Numeric vector of starting values for parameters in the true
outcome mechanism (\eqn{\theta}) and the observation mechanism (\eqn{\beta}), respectively.}

\item{beta0_fixed}{Optional numeric vector of values of the observation mechanism
intercept to profile over. If a single value is entered, this corresponds to
fixing the intercept at the specified value. The default is \code{NULL}.}

\item{weights}{Optional vector of row-specific weights used for selection bias
adjustment. The default is \code{NULL}.}

\item{expected}{A logical value indicating whether or not to calculate the
covariance matrix via the expected Fisher information matrix. The default is \code{TRUE}.}

\item{tolerance}{A numeric value specifying when to stop estimation, based on
the difference of subsequent log-likelihood estimates. The default is \code{1e-7}.}

\item{max_em_iterations}{An integer specifying the maximum number of
iterations of the EM algorithm. The default is \code{1500}.}
}
\value{
\code{perfect_sensitivity_EM} returns a list containing nine elements.
The elements are detailed in \code{?SAMBA::obsloglikEM} documentation. Code
is adapted from the \code{SAMBA::obsloglikEM} function.
}
\description{
Code is adapted by the SAMBA R package from Lauren Beesley and Bhramar Mukherjee.
}
\references{
Beesley, L. and Mukherjee, B. (2020).
Statistical inference for association studies using electronic health records:
Handling both selection bias and outcome misclassification.
Biometrics, 78, 214-226.
}
