% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_and_fix_chains.R
\name{check_and_fix_chains}
\alias{check_and_fix_chains}
\title{Check Assumption and Fix Label Switching if Assumption is Broken for a List of MCMC Samples}
\usage{
check_and_fix_chains(
  n_chains,
  chains_list,
  pistarjj_matrix,
  dim_x,
  dim_z,
  n_cat
)
}
\arguments{
\item{n_chains}{An integer specifying the number of MCMC chains to compute over.}

\item{chains_list}{A numeric list containing the samples from \code{n_chains}
MCMC chains.}

\item{pistarjj_matrix}{A numeric matrix of the average
conditional probability \eqn{P(Y^* = j | Y = j, Z)} across all subjects for
each MCMC chain, obtained from the \code{pistar_by_chain} function.}

\item{dim_x}{The number of columns of the design matrix of the true outcome mechanism, \code{X}.}

\item{dim_z}{The number of columns of the design matrix of the observation mechanism, \code{Z}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
and the observed outcome, \code{Y*} can take.}
}
\value{
\code{check_and_fix_chains} returns a numeric list of the samples from
\code{n_chains} MCMC chains which have been corrected for label switching if
the following assumption is not met: \eqn{P(Y^* = j | Y = j, Z) > 0.50 \forall j}.
}
\description{
Check Assumption and Fix Label Switching if Assumption is Broken for a List of MCMC Samples
}
