% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ggomnbd_LL}
\alias{ggomnbd_LL}
\alias{ggomnbd_nocov_LL_ind}
\alias{ggomnbd_nocov_LL_sum}
\alias{ggomnbd_staticcov_LL_ind}
\alias{ggomnbd_staticcov_LL_sum}
\title{GGompertz/NBD: Log-Likelihood functions}
\usage{
ggomnbd_nocov_LL_ind(vLogparams, vX, vT_x, vT_cal)

ggomnbd_nocov_LL_sum(vLogparams, vX, vT_x, vT_cal, vN)

ggomnbd_staticcov_LL_ind(vParams, vX, vT_x, vT_cal, mCov_life, mCov_trans)

ggomnbd_staticcov_LL_sum(vParams, vX, vT_x, vT_cal, vN, mCov_life, mCov_trans)
}
\arguments{
\item{vLogparams}{vector with the GGompertz/NBD model parameters at log scale. See Details.}

\item{vX}{Frequency vector of length n counting the numbers of purchases.}

\item{vT_x}{Recency vector of length n.}

\item{vT_cal}{Vector of length n indicating the total number of periods of observation.}

\item{vN}{The value ("number of times observed") with which the LL value of this observation is multiplied before summing across customers.}

\item{vParams}{vector with the parameters for the GGompertz/NBD model at log scale and the static covariates at original scale. See Details.}

\item{mCov_life}{Matrix containing the covariates data affecting the lifetime process. One column for each covariate.}

\item{mCov_trans}{Matrix containing the covariates data affecting the transaction process. One column for each covariate.}
}
\value{
Returns the respective Log-Likelihood value(s) for the GGompertz/NBD model
 with or without covariates.
}
\description{
Calculates the Log-Likelihood values for the GGompertz/NBD model with and without covariates.

The function \code{ggomnbd_nocov_LL_ind} calculates the individual log-likelihood
values for each customer for the given parameters.

The function \code{ggomnbd_nocov_LL_sum} calculates the log-likelihood value summed
across customers for the given parameters.

The function \code{ggomnbd_staticcov_LL_ind} calculates the individual log-likelihood
values for each customer for the given parameters and covariates.

The function \code{ggomnbd_staticcov_LL_sum} calculates the individual log-likelihood values summed
across customers.
}
\details{
\code{vLogparams} is a vector with model parameters \code{r, alpha_0, b, s, beta_0} at log-scale, in this order.

\code{vParams} is vector with the GGompertz/NBD model parameters at log scale,
followed by the parameters for the lifetime covariates at original scale and then
followed by the parameters for the transaction covariates at original scale

\code{mCov_trans} is a matrix containing the covariates data of
the time-invariant covariates that affect the transaction process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vParams} at the respective position.

\code{mCov_life} is a matrix containing the covariates data of
the time-invariant covariates that affect the lifetime process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vParams} at the respective position.
}
\references{
Bemmaor AC, Glady N (2012). \dQuote{Modeling Purchasing Behavior with Sudden \dQuote{Death}: A Flexible Customer
Lifetime Model} Management Science, 58(5), 1012-1021.

Adler J (2022).  \dQuote{Comment on “Modeling Purchasing Behavior with Sudden \dQuote{Death}: A Flexible Customer
Lifetime Model} Management Science 69(3):1929-1930.

The expression for the PMF was derived by Adler J (2024). (unpublished)
}
