% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fdet_func_GLM.R
\name{Fdet_func_GLM}
\alias{Fdet_func_GLM}
\title{Determinant of Fisher information matrix for GLM}
\usage{
Fdet_func_GLM(w, beta, X, link = "logit")
}
\arguments{
\item{w}{allocation (can be exact or approximate)}

\item{beta}{GLM model covariate coefficient}

\item{X}{model matrix}

\item{link}{link function, default"logit", choose from "logit", "cloglog", "loglog", "probit", and "identity"(for regular linear regression)}
}
\value{
the determinant of Fisher information matrix given X and model parameter beta
}
\description{
Determinant of Fisher information matrix for GLM
}
\examples{
w = c(1/3,1/3, 1/3)
beta = c(0.5, 0.5, 0.5)
X = matrix(data=c(1,-1,-1,1,-1,1,1,1,-1), byrow=TRUE, nrow=3)
Fdet_func_GLM(w=w, beta=beta, X=X, link='logit')

}
