% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxtoexact_constrained_func.R
\name{approxtoexact_constrained_func}
\alias{approxtoexact_constrained_func}
\title{Convert the approximate allocation (proportion) to exact allocation (integer) with bounded constraint (ni <= Ni)}
\usage{
approxtoexact_constrained_func(
  n,
  w,
  m,
  beta = NULL,
  link = NULL,
  X = NULL,
  Fdet_func = Fdet_func_GLM,
  iset_func = NULL
)
}
\arguments{
\item{n}{Sample size, must be a positive integer}

\item{w}{Approximate allocation/proportion, must be a real-valued vector, can get from running liftone_constrained_GLM or liftone_constrained_MLM}

\item{m}{The number of sampling groups}

\item{beta}{Model parameter coefficients, default to be NULL for use in constrained uniform sampling}

\item{link}{Link function of GLM or MLM, if used for GLM model (GLM_T is T), options are "identity", "logit", "probit", "cloglog", "loglog". If used for MLM (GLM_T is F), options are "continuation", "cumulative", "adjacent", and "baseline"}

\item{X}{Design matrix of the model for GLM or MLM, default to be NULL for use in constrained uniform sampling}

\item{Fdet_func}{determinant of Fisher information matrix function, Fdet_func can be self-defined, or use "Fdet_func_GLM", "Fdet_func_MLM" in the package, default is Fdet_func_GLM}

\item{iset_func}{self-defined function for checking which index of sampling group fall within constraint if add 1 more subject (I set, see Algorithm 2 in Huang, Tong, Yang (2023)), two example functions are provided in the package, iset_func_trial and iset_func_trauma}
}
\value{
allocation is the exact allocation or integer value of the number of subjects sampled from the group

allocation.real is the proportion or the approximate allocation of the number of subjects sampled from the group

det.maximum is the maximum of |F| from the current exact allocation
}
\description{
Convert the approximate allocation (proportion) to exact allocation (integer) with bounded constraint (ni <= Ni)
}
\examples{

beta = c(0, 3, 3, 3) #main effect model beta_0, beta_1, beta_21, beta_22
X.liftone=matrix(data=c(1,0,0,0,1,0,1,0,1,0,0,1,1,1,0,0,1,1,1,0,1,1,0,1), ncol=4, byrow=TRUE)
exact_design = approxtoexact_constrained_func(n=200, w=c(0.25, 0.20, 0.05, 0.50, 0.00, 0.00),
m=6, beta=beta, link='logit', X=X.liftone, Fdet_func=Fdet_func_GLM, iset_func=iset_func_trial)

}
