% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brazil_cnpj.R
\name{get_brazil_cnpj}
\alias{get_brazil_cnpj}
\title{Get Company Information by CNPJ (Brazil)}
\usage{
get_brazil_cnpj(cnpj)
}
\arguments{
\item{cnpj}{A valid CNPJ number as a string (only digits, no punctuation).}
}
\value{
A tibble with selected essential fields:
\itemize{
  \item \code{cnpj}: CNPJ identifier.
  \item \code{razao_social}: Legal name.
  \item \code{nome_fantasia}: Trade name.
  \item \code{capital_social}: Registered capital (numeric).
  \item \code{data_inicio_atividade}: Start date of activities.
  \item \code{cnae_fiscal_descricao}: Main economic activity.
  \item \code{natureza_juridica}: Legal nature.
  \item \code{descricao_situacao_cadastral}: Registration status.
  \item \code{municipio}: City.
  \item \code{uf}: State.
  \item \code{cep}: Postal code.
  \item \code{logradouro}: Address (street).
  \item \code{numero}: Address number.
  \item \code{bairro}: Neighborhood.
}
}
\description{
This function retrieves public company registration data in Brazil by querying the BrasilAPI endpoint.
}
\details{
Example URL format: \url{https://brasilapi.com.br/api/cnpj/v1/19131243000197}

Replace \code{19131243000197} with any valid Brazilian CNPJ number.

It returns a tibble with essential information such as the company's legal name, trade name,
address, primary activity, and registration status.


The function makes an HTTP GET request to the BrasilAPI CNPJ endpoint and processes the JSON response
into a structured tibble. It only returns fields that are essential and informative for the user.
}
\note{
Requires internet connection. The function returns \code{NULL} if the CNPJ is invalid or not found.
}
\examples{
\dontrun{
get_brazil_cnpj("19131243000197")
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
