% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpPolar-functions.R
\name{expcov_gpPolar}
\alias{expcov_gpPolar}
\title{Covariance kernel of OU process}
\usage{
expcov_gpPolar(vec, kappa)
}
\arguments{
\item{vec}{Numeric vector of input locations. \eqn{t = X'\theta} is the main input value for the single-index model.}

\item{kappa}{Non-negative numeric scalar range/decay parameter. Larger values
imply faster correlation decay.}
}
\value{
A numeric \eqn{n \times n} covariance matrix, where \eqn{n} is the length of input vector \code{vec}.
}
\description{
The \pkg{nimble} function that constructs an OU covariance matrix on the \eqn{t = X'\theta}.
The \eqn{(i, j)} entry is \eqn{K_{ij} = \exp\{-\kappa\, |\,\mathrm{t}_i - \mathrm{t}_j\,|\}},
symmetrized explicitly and stabilized with a small diagonal jitter.
}
\details{
The OU kernel (a Matérn kernel with smoothness \eqn{\nu=1/2}) induces
an exponential correlation that decays with the absolute distance.
After filling the matrix, the function enforces symmetry via
\eqn{(K + K')/2} and adds \eqn{10^{-4}} to the diagonal to improve
numerical conditioning in downstream linear algebra.
}
\seealso{
\code{\link{gpPolar}}, \code{\link{gpPolarHigh}}, \code{\link{predict.bsimGp}}
}
