% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev_ermod_lin.R
\name{dev_ermod_bin_cov_functions}
\alias{dev_ermod_bin_cov_functions}
\alias{.dev_ermod_refmodel}
\alias{.select_cov_projpred}
\title{Internal functions for developing an ER model with covariates
for binary endpoint}
\usage{
.dev_ermod_refmodel(
  data,
  var_resp,
  var_exposure,
  var_cov_candidates,
  verbosity_level = 1,
  chains = 4,
  iter = 2000,
  fun_family = quote(stats::binomial())
)

.select_cov_projpred(
  refm_obj,
  var_exposure,
  var_cov_candidates,
  nterms_max = NULL,
  cv_method = c("LOO", "kfold"),
  k = 5,
  .reduce_obj_size = TRUE,
  validate_search = FALSE,
  verbosity_level = 1
)
}
\arguments{
\item{data}{Input data for E-R analysis}

\item{var_resp}{Response variable name in character}

\item{var_exposure}{Exposure variable names in character}

\item{var_cov_candidates}{Candidate covariate names in character vector}

\item{verbosity_level}{Verbosity level. 0: No output, 1: Display steps,
2: Display progress in each step, 3: Display MCMC sampling.}

\item{chains}{Number of chains for Stan.}

\item{iter}{Number of iterations for Stan.}

\item{fun_family}{Family function for the model. Default is binomial.}

\item{refm_obj}{Reference model object used for variable selection}

\item{nterms_max}{Maximum number of terms to consider in the model.
Default is NULL (all terms are considered).}

\item{cv_method}{Cross-validation method. Default is "LOO" (recommended).
Use "kfold" if you see warnings on Pareto k estimates.}

\item{k}{Number of folds for kfold CV.
Only used if cv_method is "kfold".}

\item{.reduce_obj_size}{Whether to reduce object size by removing some
elements from projpred outputs that are not necessary for the functionality
of this package.}

\item{validate_search}{Whether to validate the search. Default is FALSE.
Recommend to set to TRUE for kfold CV. Do not use for LOO (run time would
become too long).}
}
\value{
\code{\link[=.dev_ermod_refmodel]{.dev_ermod_refmodel()}}: The reference model object that can be used
for variable selection.

\code{\link[=.select_cov_projpred]{.select_cov_projpred()}}: The selected variables
}
\description{
These functions are not intended to be used directly by users.
}
\details{
\code{\link[=.dev_ermod_refmodel]{.dev_ermod_refmodel()}} is used to fit the refmodel (full reference
model) necessary for projpred

\code{\link[=.select_cov_projpred]{.select_cov_projpred()}} is used to select variables with \code{projpred} package
}
\keyword{internal}
