% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustCpObj.R
\name{ClustCpObj}
\alias{ClustCpObj}
\title{ClustCpObj class constructor}
\usage{
ClustCpObj(
  data = NULL,
  n_iterations = NULL,
  n_burnin = NULL,
  clust = NULL,
  orders = NULL,
  time = NULL,
  lkl = NULL,
  norm_vec = NULL,
  I0_MCMC = NULL,
  I0_MCMC_01 = NULL,
  kernel_ts = NULL,
  kernel_epi = NULL,
  univariate_ts = NULL
)
}
\arguments{
\item{data}{a vector or a matrix containing the values of the time series;}

\item{n_iterations}{number of iterations of the MCMC algorithm;}

\item{n_burnin}{number of MCMC iterations to exclude in the posterior estimate;}

\item{clust}{a matrix with the clustering of each iteration.}

\item{orders}{a matrix where each row corresponds to the output order of the corresponding iteration;}

\item{time}{computational time in seconds;}

\item{lkl}{a vector with the likelihood of the final clustering.}

\item{norm_vec}{a vector with the estimated normalization constant.}

\item{I0_MCMC}{traceplot for \eqn{I_0}.}

\item{I0_MCMC_01}{a \eqn{0/1} vector, the \eqn{n}-th element is equal to \eqn{1} if the proposed \eqn{I_0} was accepted, \eqn{0} otherwise.}

\item{kernel_ts}{if TRUE data are time series.}

\item{kernel_epi}{if TRUE data are survival functions.}

\item{univariate_ts}{TRUE/FALSE if time series is univariate or not;}
}
\description{
A constructor for the \code{ClustCpObj} class. The class \code{ClustCpObj} contains...
}
