% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/cardinality.R
\name{cardinality}
\alias{cardinality}
\alias{cardinality,TidySet-method}
\title{Cardinality or membership of sets}
\usage{
cardinality(object, sets = NULL, ...)

\S4method{cardinality}{TidySet}(object, sets, FUN = "sum", ...)
}
\arguments{
\item{object}{A TidySet object.}

\item{sets}{Character vector with the name of the sets.}

\item{...}{Other arguments passed to \code{FUN}.}

\item{FUN}{Function that returns a single numeric value given a vector of
fuzzy values.}
}
\description{
Calculates the membership of sets according to the logic defined in FUN.
}
\section{Methods (by class)}{
\itemize{
\item \code{cardinality(TidySet)}: Cardinality of sets

}}
\examples{
rel <- list(A = letters[1:3], B = letters[1:2])
TS <- tidySet(rel)
cardinality(TS, "A")
}
\seealso{
\code{\link[=size]{size()}}
}
