% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitPlot.R
\name{synergy_plot_bycomp}
\alias{synergy_plot_bycomp}
\title{Plot 2D cross section of response surface}
\usage{
synergy_plot_bycomp(ls, xlab = NULL, ylab = NULL, color = FALSE, plotBy = NULL)
}
\arguments{
\item{ls}{list of results objects obtained from \code{\link{fitSurface}}. Names of list objects 
expected to be one of the null model options i.e. loewe, loewe2, hsa, bliss}

\item{xlab}{label for x-axis}

\item{ylab}{label for y-axis}

\item{color}{plot lines in colour? Defaults to FALSE}

\item{plotBy}{compound name to be used for order of plotting. If plotBy = "Compound 1" then plots are split by 
concentrations in Compound 1 and concentrations in Compound 2 are shown on the x-axis.}
}
\description{
Plot 2D cross section of response surface
}
\examples{
\dontrun{
  data <- subset(directAntivirals, experiment == 1)
  transforms <- list("PowerT" = function(x, args) with(args, log(x)),
                     "InvPowerT" = function(y, args) with(args, exp(y)),
                     "BiolT" = function(x, args) with(args, N0 * exp(x * time.hours)),
                     "InvBiolT" = function(y, args) with(args, 1/time.hours * log(y/N0)),
                     "compositeArgs" = list(N0 = 1, time.hours = 72))
  fitResult <- fitMarginals(data, transforms)
  nullModels <- c("loewe", "loewe2", "bliss", "hsa")
  rs_list <- Map(fitSurface, null_model = nullModels, MoreArgs = list(
      data = data, fitResult = fitResult, B.CP = 50, statistic = "none"))
  synergy_plot_bycomp(ls = rs_list, plotBy = "Compound 1", color = TRUE)
  synergy_plot_bycomp(ls = rs_list, plotBy = "Compound 2", color = TRUE)
} 
}
\author{
Mohammed Ibrahim
}
