% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotReponseSurface.R
\name{plotResponseSurface}
\alias{plotResponseSurface}
\title{Plot response surface}
\usage{
plotResponseSurface(
  data,
  fitResult = NULL,
  transforms = fitResult$transforms,
  predSurface = NULL,
  null_model = c("loewe", "hsa", "bliss", "loewe2"),
  colorPalette = c("red", "grey70", "blue"),
  colorPaletteNA = "grey70",
  colorBy = "none",
  addPoints = TRUE,
  colorPoints = c("black", "sandybrown", "brown", "white"),
  breaks,
  radius = 4,
  logScale = TRUE,
  colorfun = median,
  zTransform = function(x) x,
  add = FALSE,
  main = "",
  legend = FALSE,
  xat = "actual",
  yat = "actual",
  plotfun = NULL,
  gradient = TRUE,
  width = 800,
  height = 800,
  title = "",
  digitsFunc = function(x) {
     x
 },
  reverse = FALSE,
  ...
)
}
\arguments{
\item{data}{Object "data" from the output of \code{\link{fitSurface}}}

\item{fitResult}{Object "fitResult" from the output of \code{\link{fitSurface}}}

\item{transforms}{Object "transforms" from the output of \code{\link{fitSurface}}}

\item{predSurface}{Vector of all predicted responses based on
\code{expand.grid(uniqueDoses)}. If not supplied, it will be computed
with \code{\link{predictOffAxis}} function.}

\item{null_model}{If \code{predSurface} is not supplied, it is computed using
one of the available null models, i.e. \code{"loewe"}, \code{"hsa"}, 
\code{"bliss"} and \code{"loewe2"}. See also \code{\link{fitSurface}}.}

\item{colorPalette}{Vector of color names for surface}

\item{colorPaletteNA}{Color used in the matrix of colours when the combination of doses doesn't exist (NA)}

\item{colorBy}{This parameter determines values on which coloring is based
for the 3-dimensional surface. If matrix or a data frame with \code{d1} and
\code{d2} columns is supplied, dose combinations from \code{colorBy} will be
matched automatically to the appropriate dose combinations in \code{data}.
Unmatched dose combinations will be set to 0. This is especially useful for
plotting results for off-axis estimates only, e.g. off-axis Z-scores or
maxR test statistics. If \code{colorBy = "colors"}, surface will be colored
using colors in \code{colorPalette} argument.}

\item{addPoints}{Boolean whether the dose points should be included}

\item{colorPoints}{Colors for off-axis and on-axis points. Character vector
of length four with colors for 1) off-axis points; 2) on-axis points of the
first drug (i.e. second drug is dosed at zero); 3) on-axis points of the
second drug; 4) on-axis points where both drugs are dosed at zero.}

\item{breaks}{Numeric vector with numerical breaks. To be used in conjunction
with \code{colorPalette} argument. If named, the labels will be displayed in the legend}

\item{radius}{Size of spheres (default is 4)}

\item{logScale}{Draw doses on log-scale (setting zeroes to be finite constant)}

\item{colorfun}{If replicates in \code{colorBy} variable are present, these
will be aggregated using \code{colorfun} function. This can also be a
custom function returning a scalar.}

\item{zTransform}{Optional transformation function for z-axis. By default,
identity function is used.}

\item{add}{(deprecated) Add the predicted response surface to an existing plot. Will not
draw any points, just the surface. Must be called after another call to
\code{\link{plotResponseSurface}}.}

\item{main}{Fixed non-moving title for the 3D plot}

\item{legend}{Whether legend should be added (default FALSE)}

\item{xat}{x-axis ticks: "pretty", "actual" or a numeric vector}

\item{yat}{y-axis ticks: "pretty", "actual" or a numeric vector}

\item{plotfun}{If replicates for dose combinations in \code{data} are
available, points can be aggregated using \code{plotfun} function.
Typically, it will be \code{\link{mean}}, \code{\link[stats]{median}},
\code{\link{min}} or \code{\link{max}} but a custom-defined function
returning a scalar from a vector is also possible.}

\item{gradient}{Boolean indicating whether colours should be interpolated between breaks (default TRUE). 
If FALSE, \code{colorPalette} must contain length(breaks)-1 colours}

\item{width}{Width in pixels (optional, defaults to 800px).}

\item{height}{Height in pixels (optional, defaults to 800px).}

\item{title}{String title (default "")}

\item{digitsFunc}{Function to be applied to the axis values}

\item{reverse}{Boolean indicating whether colours should be reversed (default FALSE).}

\item{...}{Further arguments to format axis labels}
}
\value{
Plotly plot
}
\description{
Plot the 3-dimensional response surface predicted by one of the null
models. This plot allows for a visual comparison between the null
model prediction and observed points. This function is mainly used
as the workhorse of \code{\link{plot.ResponseSurface}} method.
}
\examples{
\dontrun{
  data <- subset(directAntivirals, experiment == 1)
  ## Data must contain d1, d2 and effect columns
  fitResult <- fitMarginals(data)
  data_mean <- aggregate(effect ~ d1 + d2, data = data[, c("d1", "d2", "effect")],
                         FUN = mean)

  ## Construct the surface from marginal fit estimates based on HSA
  ## model and color it by mean effect level
  plotResponseSurface(data, fitResult, null_model = "hsa",
                      colorBy = data_mean, breaks = 10^(c(0, 3, 4, 6)),
                      colorPalette = c("grey", "blue", "green"))

  ## Response surface based on Loewe additivity model and colored with
  ## rainbow colors.
  plotResponseSurface(data, fitResult, null_model = "loewe", breaks = c(-Inf, 0, Inf),
                      colorBy = "colors", colorPalette = rainbow(6))
}
}
