% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{purge_key_vault}
\alias{purge_key_vault}
\title{Purge a deleted Azure Key Vault}
\description{
Method for the \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} and \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} classes.
}
\details{
This method permanently deletes a soft-deleted key vault. Note that it will fail if the vault has purge protection enabled.
}
\section{Usage}{
\preformatted{purge_key_vault(name, location, confirm=TRUE)
}
}

\section{Arguments}{

\itemize{
\item \code{name},\code{location}: The name and location of the key vault.
\item \code{confirm}: Whether to ask for confirmation before permanently deleting the vault.
}
}

\section{Value}{

NULL on successful purging.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# assuming the vault has soft-delete enabled, and is in the same location as its RG
rg$delete_key_vault("mykeyvault")
rg$purge_key_vault("mykeyvault", rg$location)

}
}
\seealso{
\link{create_key_vault}, \link{get_key_vault}, \link{delete_key_vault}, \link{list_deleted_key_vaults}, \link{az_key_vault},

\href{https://docs.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://docs.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
