% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitters.R
\name{uniRIntSplit}
\alias{uniRIntSplit}
\title{Univariate random integer splitting}
\usage{
uniRIntSplit(bin, minExp = 5, on = "y")
}
\arguments{
\item{bin}{a bin to be split with elements `x`, `y`, `depth`,
`bnds` (list with elements `x` and `y`), `expn`, `n`}

\item{minExp}{numeric giving the minimum expected count allowed
in a bin}

\item{on}{one of "x" or "y": the margin to split}
}
\value{
A list of two bins resulting from the split of `bin`
along the corresponding margin at the maximum location
}
\description{
A function which splits a bin along x at a random
integer conforming to limits on minimum bin size.
}
\details{
This function serves as a wrapper which manages the
interaction of a score function, marginal splitting functions,
tie breaking function, and a maximum selection function to split
a bin along a single margin at the observation coordinate which
maximizes the score function.
}
\examples{
bin <- makeBin(x = 1:10, y = sample(1:10))
rIntSplit(bin, minExp = 2)
}
\author{
Chris Salahub
}
