% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{setMarkerHaplo}
\alias{setMarkerHaplo}
\title{Set marker haplotypes}
\usage{
setMarkerHaplo(pop, haplo, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{RawPop-class}} or
\code{\link{MapPop-class}}}

\item{haplo}{a matrix of haplotypes, see details}

\item{simParam}{an object of \code{\link{SimParam}}, not 
used if pop is \code{\link{MapPop-class}}}
}
\value{
an object of the same class as the "pop" input
}
\description{
Manually sets the haplotypes in a population 
for all individuals at one or more loci.
}
\details{
The format of the haplotype matrix should match 
the format of the output from \code{\link{pullMarkerHaplo}}
with the option haplo="all". Thus, it is recommended that this 
function is first used to extract the haplotypes and that any 
desired changes be made to the output of pullMarkerHaplo before 
passing the matrix to setMarkerHaplo. Any changes made to QTL 
may potentially result in changes to an individuals genetic 
value. These changes will be reflected in the gv and/or gxe slot. 
All other slots will remain unchanged, so the ebv and pheno slots 
will not reflect the new genotypes.
}
\examples{
# Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=15)

# Extract haplotypes for marker "1_1"
H = pullMarkerHaplo(founderPop, markers="1_1")

# Set the first haplotype to 1
H[1,1] = 1L

# Set marker haplotypes
founderPop = setMarkerHaplo(founderPop, haplo=H)

}
