% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{selIndex}
\alias{selIndex}
\title{Selection index}
\usage{
selIndex(Y, b, scale = FALSE)
}
\arguments{
\item{Y}{a matrix of trait values}

\item{b}{a vector of weights}

\item{scale}{should Y be scaled and centered}
}
\description{
Calculates values of a selection index given trait values and 
weights. This function is intended to be used in combination with 
selection functions working on populations such as 
\code{\link{selectInd}}.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
#Model two genetically correlated traits
G = 1.5*diag(2)-0.5 #Genetic correlation matrix
SP$addTraitA(10, mean=c(0,0), var=c(1,1), corA=G)
SP$setVarE(h2=c(0.5,0.5))

#Create population
pop = newPop(founderPop, simParam=SP)

#Calculate Smith-Hazel weights
econWt = c(1, 1)
b = smithHazel(econWt, varG(pop), varP(pop))

#Selection 2 best individuals using Smith-Hazel index
#selIndex is used as a trait
pop2 = selectInd(pop, nInd=2, trait=selIndex, 
                 simParam=SP, b=b)

}
