% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_elements.R
\name{prepare_elements_from_BED4}
\alias{prepare_elements_from_BED4}
\title{Prepares element coords from a BED4 file}
\usage{
prepare_elements_from_BED4(fname)
}
\arguments{
\item{fname}{The file name of a BED4 file containing the desired elements. For further documentation
on the BED4 format, refer to the UCSC website.}
}
\value{
A data frame containing the following columns to be used as the input element coords
to ActiveDriverWGS
\describe{
    \item{chr}{autosomal chromosomes as chr1 to chr22 and sex chromosomes as chrX and chrY}
    \item{start}{the start position of the element in base 0 coordinates (BED format)}
    \item{end}{the end position of the element in base 0 coordinates (BED format)}
    \item{id}{the element identifier - if the element contains multiple segments such as exons,
    each segment should be a separate row with the segment coordinates
    and the element identifier as id. Elements can be coding or noncoding such as exons of protein
    coding genes or active enhancers.}
}
}
\description{
Prepares element coords from a BED4 file
}
\examples{
elements = prepare_elements_from_BED4(system.file("extdata",
"mini.ptm.bed",
package = "ActiveDriverWGS",
mustWork = TRUE))

}
