% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_alarm_metrics_summary.R
\name{create_alarm_metrics_summary}
\alias{create_alarm_metrics_summary}
\title{Create Alarm Metrics Summary}
\usage{
create_alarm_metrics_summary(metrics, best_models, epidemic_data)
}
\arguments{
\item{metrics}{An object of class "alarm_metrics" containing matrices for different metrics.}

\item{best_models}{A list of data frames, each containing the best model for a specific metric.}

\item{epidemic_data}{A data frame containing the epidemic data, including ScYr, Date, and ref_date columns.}
}
\value{
An object of class "alarm_metrics_summary" containing summary statistics, best values,
reference dates, and best prediction dates for each metric and epidemic year.
}
\description{
This function creates a summary of alarm metrics, including statistics for each metric,
best model parameters, reference dates, and best prediction dates for each epidemic year.
}
\examples{
# Generate sample data
set.seed(123)

# Generate sample metrics
generate_metric_matrix <- function() {
  matrix(runif(15 * 11), nrow = 15, ncol = 11,
         dimnames = list(paste("Lag", 1:15),
                         paste("Threshold", seq(0.1, 0.6, by = 0.05))))
}

sample_metrics <- list(
  FAR = generate_metric_matrix(),
  ADD = generate_metric_matrix(),
  AATQ = generate_metric_matrix(),
  FATQ = generate_metric_matrix(),
  WAATQ = generate_metric_matrix(),
  WFATQ = generate_metric_matrix()
)

metrics <- structure(sample_metrics, class = c("alarm_metrics", "list"))

# Generate sample best models
generate_best_model <- function() {
  data.frame(
    ScYr = rep(1:3, each = 100),
    Date = rep(1:100, 3),
    Alarm = sample(c(0, 1), 300, replace = TRUE, prob = c(0.9, 0.1)),
    lag = sample(1:15, 300, replace = TRUE),
    thres = runif(300, 0.1, 0.6)
  )
}

best_models <- list(
  best.FAR = generate_best_model(),
  best.ADD = generate_best_model(),
  best.AATQ = generate_best_model(),
  best.FATQ = generate_best_model(),
  best.WAATQ = generate_best_model(),
  best.WFATQ = generate_best_model()
)

# Generate sample epidemic data
epidemic_data <- data.frame(
  ScYr = rep(1:3, each = 365),
  Date = rep(1:365, 3),
  ref_date = c(rep(0, 364), 1)
)

# Create alarm metrics summary
summary <- create_alarm_metrics_summary(metrics, best_models, epidemic_data)

# Print summary
print(summary)

}
