% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selections.R
\name{sim_selection_weights}
\alias{sim_selection_weights}
\title{Create parameters and simulate selection weights}
\usage{
sim_selection_weights(
  min_range = c(-70, 240),
  min_mean = 30,
  min_sd = 60,
  day_range = c(120, 201),
  day_mean = 161,
  day_sd = 20,
  offset = 0,
  return_log = TRUE,
  selection_fun = "norm",
  selection_var = "psel_normalized",
  return_params = TRUE,
  plot = TRUE
)
}
\arguments{
\item{min_range}{Numeric vector. Range of the sampling distribution of
minutes around the sun event.}

\item{min_mean}{Numeric. Mean of the sampling distribution of minutes to the
sun event.}

\item{min_sd}{Numeric. SD in minutes of the sampling distribution of minutes
around the sun event.}

\item{day_range}{Date/Datetime/Numeric vector. Range of sampling distribution
of days. Can be Dates, Date-times, or DOY (day-of-year, 1-366).}

\item{day_mean}{Date/Datetime/Numeric. Mean date of the sampling distribution
of days. Can be Date, Date-time, or DOY (day-of-year, 1-366).}

\item{day_sd}{Numeric. SD in days of the sampling distribution of days.}

\item{offset}{Numeric. Offset to shift for time of day in minutes.}

\item{return_log}{Logical. Log the density in the selection function?}

\item{selection_fun}{Character. Selection function to use. Options are
\code{lognorm}, \code{norm} (default), or \code{cauchy}.}

\item{selection_var}{Character. Selection variable to plot
(if \code{plot = TRUE}). Options are are \code{psel}, \code{psel_doy}, \code{psel_min},
\code{psel_std}, \code{psel_scaled}, or \code{psel_normalized} (default).}

\item{return_params}{Logical. Return parameter list for use in
calc_selection_weights()?}

\item{plot}{Logical. Create plot of simulated selection weights? If
\code{return_param = TRUE} and \code{plot = TRUE} plot is created as a side effect.
Other wise, plot is returned directly.}
}
\value{
Returns either a list of selection parameters or a plot of simulated
selection weights
}
\description{
This function creates and explores parameters for generating selections.
These parameters define the selection distribution of minutes (\code{min}) around
the sun event (sunrise/sunset), as well as of days (\code{day}).
}
\examples{
params <- sim_selection_weights()
}
