% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_patterns.R
\name{create_lookaround}
\alias{create_lookaround}
\title{Create a look around expression and add it to an
existing regular expression}
\usage{
create_lookaround(pattern, lookaround_pattern, position, negate = FALSE)
}
\arguments{
\item{pattern}{String. Pattern that you wish to add a look around to}

\item{lookaround_pattern}{String. Pattern that you wish to look for.}

\item{position}{String. One of 'before', 'after', 'ahead', or 'behind'. Capitalization doesn't matter}

\item{negate}{Logical. allows you to exclude cases where look around is detected.}
}
\value{
Returns a string that can be used as a regular expression
}
\description{
Lookarounds allow you to position a regular expression to more
specificity.
}
\examples{

# Here is a string with three patterns of digits
text <- "cars123ruin456cities789"

# To extract the first one we can use this pattern
stringr::str_extract(text, "\\\\d{3}")
# or
create_lookaround("\\\\d{3}", "cars", "before") |>
stringr::str_extract(string=text)

# To exclude the first one we can write
create_lookaround("\\\\d{3}", "cars", "before", negate=TRUE) |>
stringr::str_extract_all(string=text)

# To extract the second one we can write
 create_lookaround("\\\\d{3}", "ruin", "before") |>
stringr::str_extract(string=text)

# or

create_lookaround("\\\\d{3}", "cities", "after") |>
stringr::str_extract(string=text)


}
