% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_sun.R
\name{calc_sun}
\alias{calc_sun}
\title{Calculate time to sunrise/sunset}
\usage{
calc_sun(meta_sites, aru_tz = "local")
}
\arguments{
\item{meta_sites}{(Spatial) Data frame. Recording metadata with added
coordinates. Output of \code{clean_metadata()} and then \code{add_sites()} (with
either \code{clean_gps()} or \code{clean_site_index()}).}

\item{aru_tz}{Character. Must be either "local" or a timezone listed in
\code{OlsonNames()}. See Details.}
}
\value{
Data frame with metadata and added timezone of recording time (\code{tz}),
and time to sunrise/sunset (\code{t2sr}, \code{t2ss}).
}
\description{
Calculate the sunrise/sunset of each sound file for the day of, the day before
and the day after to get the nearest sunrise to the recording. Times are
calculated using the 'suncalc' package.
}
\details{
Timezones. To ensure that the sunrise/sunset times are calculated
correctly relative to the time of the recording, we need to know the
timezone of the date/time of the recording. If ARUs were calibrated with a
specific timezone before going into the field, that can be specified by
using, for example, \code{aru_tz = "America/Toronto"}. If on the other hand each
ARU was calibrated to whichever timezone was local when it was deployed use
\code{aru_tz = "local"}. The specific timezone will be calculated individually
based on the longitude and latitude of each recording.
}
\examples{
s <- clean_site_index(example_sites_clean,
  name_date = c("date_time_start", "date_time_end")
)
m <- clean_metadata(project_files = example_files) |>
  add_sites(s)
calc_sun(m)

}
