% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARPALdf_Summary_map.R
\name{ARPALdf_Summary_map}
\alias{ARPALdf_Summary_map}
\title{Generate a map of summary statistics for a given ARPALdf data.frame}
\usage{
ARPALdf_Summary_map(
  Data,
  Title_main,
  Title_legend = "Variable",
  Variable,
  prov_line_type = 1,
  prov_line_size = 1,
  col_scale = c("#00FF00", "#FFFF00", "#FF0000"),
  val_midpoint = NULL,
  xlab = "Longitude",
  ylab = "Latitude"
)
}
\arguments{
\item{Data}{Dataset of class 'ARPALdf' containing the values or the descriptive statistics to plot on the map.
Data can be either a ARPALdf of observed data (from 'get_ARPA_Lombardia_xxx' commands) and an ARPALdf obtained
as summary descriptive statistic (from 'ARPALdf_Summary' command).}

\item{Title_main}{Title of the plot.}

\item{Title_legend}{Title fo the legend}

\item{Variable}{Summary variable to represent}

\item{prov_line_type}{Linetype for Lombardy provinces. Default is 1.}

\item{prov_line_size}{Size of the line for Lombardy provinces. Default is 1.}

\item{col_scale}{Vector indicating the minimum, the middle and the average point colors.
Default is c("green","yellow","red").}

\item{val_midpoint}{Numeric. Value associated to the middle-point scale color.
Default is NULL (midpoint is set equal to the average of the variable to represent).}

\item{xlab}{x-axis label. Default is 'Longitude'.}

\item{ylab}{y-axis label. Default is 'Latitude'.}
}
\value{
A map of selected stations across the Lombardy region
}
\description{
'ARPALdf_Summary_map' represents on a map (polygon of Lombardy) the data contained in a data frame
of class 'ARPALdf' containing the values or the descriptive statistics by station. Data can be either
a ARPALdf of observed data (from 'get_ARPA_Lombardia_xxx' commands) and an ARPALdf obtained as summary descriptive
statistic (from 'ARPALdf_Summary' command).
}
\examples{
\donttest{
## Download daily air quality data from all the stations for year 2020
if (require("RSocrata")) {
    d <- get_ARPA_Lombardia_AQ_data(ID_station = NULL, Date_begin = "2020-01-01",
              Date_end = "2020-12-31", Frequency = "daily")
}
## Summarising observed data
s <- ARPALdf_Summary(Data = d)
## Mapping of the average NO2 in 2020 at several stations
ARPALdf_Summary_map(Data = s$Descr_by_IDStat$Mean_by_stat,
        Title_main = "Mean NO2 by station in 2020", Variable = "NO2")
}

}
