% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{antimicrobials}
\alias{antimicrobials}
\alias{antibiotics}
\alias{antivirals}
\title{Data Sets with 617 Antimicrobial Drugs}
\format{
\subsection{For the \link{antimicrobials} data set: a \link[tibble:tibble]{tibble} with 497 observations and 14 variables:}{
\itemize{
\item \code{ab}\cr antimicrobial ID as used in this package (such as \code{AMC}), using the official EARS-Net (European Antimicrobial Resistance Surveillance Network) codes where available. \emph{\strong{This is a unique identifier.}}
\item \code{cid}\cr Compound ID as found in PubChem. \emph{\strong{This is a unique identifier.}}
\item \code{name}\cr Official name as used by WHONET/EARS-Net or the WHO. \emph{\strong{This is a unique identifier.}}
\item \code{group}\cr A short and concise group name, based on WHONET and WHOCC definitions
\item \code{atc}\cr ATC codes (Anatomical Therapeutic Chemical) as defined by the WHOCC, like \code{J01CR02} (last updated May 4th, 2025):
\item \code{atc_group1}\cr Official pharmacological subgroup (3rd level ATC code) as defined by the WHOCC, like \code{"Macrolides, lincosamides and streptogramins"}
\item \code{atc_group2}\cr Official chemical subgroup (4th level ATC code) as defined by the WHOCC, like \code{"Macrolides"}
\item \code{abbr}\cr List of abbreviations as used in many countries, also for antimicrobial susceptibility testing (AST)
\item \code{synonyms}\cr Synonyms (often trade names) of a drug, as found in PubChem based on their compound ID
}

ATC properties (last updated May 4th, 2025):
\itemize{
\item \code{oral_ddd}\cr Defined Daily Dose (DDD), oral treatment, currently available for 180 drugs
\item \code{oral_units}\cr Units of \code{oral_ddd}
\item \code{iv_ddd}\cr Defined Daily Dose (DDD), parenteral (intravenous) treatment, currently available for 153 drugs
\item \code{iv_units}\cr Units of \code{iv_ddd}
}

LOINC:
\itemize{
\item \code{loinc}\cr All codes associated with the name of the antimicrobial drug from Logical Observation Identifiers Names and Codes (LOINC), Version 2.76 (18 September, 2023). Use \code{\link[=ab_loinc]{ab_loinc()}} to retrieve them quickly, see \code{\link[=ab_property]{ab_property()}}.
}
}

\subsection{For the \link{antivirals} data set: a \link[tibble:tibble]{tibble} with 120 observations and 11 variables:}{
\itemize{
\item \code{av}\cr Antiviral ID as used in this package (such as \code{ACI}), using the official EARS-Net (European Antimicrobial Resistance Surveillance Network) codes where available. \emph{\strong{This is a unique identifier.}} Combinations are codes that contain a \code{+} to indicate this, such as \code{ATA+COBI} for atazanavir/cobicistat.
\item \code{name}\cr Official name as used by WHONET/EARS-Net or the WHO. \emph{\strong{This is a unique identifier.}}
\item \code{atc}\cr ATC codes (Anatomical Therapeutic Chemical) as defined by the WHOCC, see \emph{Details}
\item \code{cid}\cr Compound ID as found in PubChem. \emph{\strong{This is a unique identifier.}}
\item \code{atc_group}\cr Official pharmacological subgroup (3rd level ATC code) as defined by the WHOCC
\item \code{synonyms}\cr Synonyms (often trade names) of a drug, as found in PubChem based on their compound ID
\item \code{oral_ddd}\cr Defined Daily Dose (DDD), oral treatment
\item \code{oral_units}\cr Units of \code{oral_ddd}
\item \code{iv_ddd}\cr Defined Daily Dose (DDD), parenteral treatment
\item \code{iv_units}\cr Units of \code{iv_ddd}
\item \code{loinc}\cr All codes associated with the name of the antiviral drug from Logical Observation Identifiers Names and Codes (LOINC), Version 2.76 (18 September, 2023). Use \code{\link[=av_loinc]{av_loinc()}} to retrieve them quickly, see \code{\link[=av_property]{av_property()}}.
}
}

An object of class \code{deprecated_amr_dataset} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 497 rows and 14 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 120 rows and 11 columns.
}
\source{
\itemize{
\item WHO Collaborating Centre for Drug Statistics Methodology, Guidelines for ATC classification and DDD assignment, Oslo Accessed from \url{https://atcddd.fhi.no/atc_ddd_index/} on May 4th, 2025.
\item Logical Observation Identifiers Names and Codes (LOINC), Version 2.76 (18 September, 2023). Accessed from \url{https://loinc.org} on October 19th, 2023.
\item European Commission Public Health PHARMACEUTICALS - COMMUNITY REGISTER: \url{https://ec.europa.eu/health/documents/community-register/html/reg_hum_atc.htm}
}
}
\usage{
antimicrobials

antibiotics

antivirals
}
\description{
Two data sets containing all antimicrobials and antivirals. Use \code{\link[=as.ab]{as.ab()}} or one of the \code{\link[=ab_property]{ab_*}} functions to retrieve values from the \link{antimicrobials} data set. Three identifiers are included in this data set: an antimicrobial ID (\code{ab}, primarily used in this package) as defined by WHONET/EARS-Net, an ATC code (\code{atc}) as defined by the WHO, and a Compound ID (\code{cid}) as found in PubChem. Other properties in this data set are derived from one or more of these codes. Note that some drugs have multiple ATC codes.

\strong{The \code{antibiotics} data set has been renamed to \code{antimicrobials}. The old name will be removed in a future version.}
}
\details{
Properties that are based on an ATC code are only available when an ATC is available. These properties are: \code{atc_group1}, \code{atc_group2}, \code{oral_ddd}, \code{oral_units}, \code{iv_ddd} and \code{iv_units}. Do note that ATC codes are not unique. For example, J01CR02 is officially the ATC code for "amoxicillin and beta-lactamase inhibitor". Consequently, these two items from the \link{antimicrobials} data set both return \code{"J01CR02"}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ab_atc("amoxicillin/clavulanic acid")
ab_atc("amoxicillin/sulbactam")
}\if{html}{\out{</div>}}

Synonyms (i.e. trade names) were derived from the PubChem Compound ID (column \code{cid}) and are consequently only available where a CID is available.
}
\section{Download Our Reference Data}{

All reference data sets in the AMR package - including information on microorganisms, antimicrobials, and clinical breakpoints - are freely available for download in multiple formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, and Stata.

For maximum compatibility, we also provide machine-readable, tab-separated plain text files suitable for use in any software, including laboratory information systems.

Visit \href{https://amr-for-r.org/articles/datasets.html}{our website for direct download links}, or explore the actual files in \href{https://github.com/msberends/AMR/tree/main/data-raw/datasets}{our GitHub repository}.
}

\section{WHOCC}{

This package contains \strong{all ~550 antibiotic, antimycotic and antiviral drugs} and their Anatomical Therapeutic Chemical (ATC) codes, ATC groups and Defined Daily Dose (DDD) from the World Health Organization Collaborating Centre for Drug Statistics Methodology (WHOCC, \url{https://atcddd.fhi.no}) and the Pharmaceuticals Community Register of the European Commission (\url{https://ec.europa.eu/health/documents/community-register/html/reg_hum_atc.htm}).

These have become the gold standard for international drug utilisation monitoring and research.

The WHOCC is located in Oslo at the Norwegian Institute of Public Health and funded by the Norwegian government. The European Commission is the executive of the European Union and promotes its general interest.

\strong{NOTE: The WHOCC copyright does not allow use for commercial purposes, unlike any other info from this package.} See \url{https://atcddd.fhi.no/copyright_disclaimer/.}
}

\examples{
antimicrobials
antivirals
}
\seealso{
\link{microorganisms}, \link{intrinsic_resistant}
}
\keyword{datasets}
