% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFM3DPrinter.R
\name{exportToSTL}
\alias{exportToSTL}
\title{Export an AFM Image as a STL format file.}
\usage{
exportToSTL(AFMImage3DModelAnalysis, AFMImage, stlfullfilename)
}
\arguments{
\item{AFMImage3DModelAnalysis}{an \code{\link{AFMImage3DModelAnalysis}}}

\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}

\item{stlfullfilename}{directory and filename to save as a stl file}
}
\description{
Export an \code{\link{AFMImage}} as a STL format file thanks to the \code{\link{rgl}} package. The STL file can be used as an input for a 3D printing software tool.\cr\cr
exportToSTL is compatible with slicr (http://slic3r.org) version 1.2.9 (GPL v3 licence).\cr
In order to 3D print the AFM Image with slic3r, do as following:
\itemize{
\item Use "File> Repair STL file..." menu option to create a file with the obj extension.
\item Use "Add" button below the menu to display your AFM Image on the print board
\item Right click on your AFM image. Use "Scale> uniformely" option, Set "15%"  for your AFM image to fit your printing board
}
}
\examples{
\dontrun{
library(AFM)
data("AFMImageOfRegularPeaks")
AFMImage<-AFMImageOfRegularPeaks
# calculate the 3D model : surface and the faces
AFMImage3DModelAnalysis<-new ("AFMImage3DModelAnalysis")
AFMImage3DModelAnalysis<-calculate3DModel(AFMImage3DModelAnalysis= AFMImage3DModelAnalysis,
                                          AFMImage= AFMImage)
# export the 3D model to file
exportDirectory=tempdir()
print(paste("saving model in ", exportDirectory))
exportToSTL(AFMImage3DModelAnalysis=AFMImage3DModelAnalysis,
            AFMImage=AFMImage, 
            stlfullfilename=paste(exportDirectory, "myFile.stl", sep="/"))
}
}
\author{
M.Beauvais
}
