\name{loglik} 
\alias{loglik} 
\title{Calculates the log likelihood of a population model, given a calibrated date PD matrix} 
\description{Calculates the log likelihood of a population model, given a calibrated date PD matrix}
\usage{loglik(PD, model)}
\arguments{
  \item{PD}{
	A data frame of Probability Distributions (PDs). Each column representing the PD of a calibrated observation or phase. Row names correspond to the calendar years BP. This data frame can be generated by \code{\link[=phaseCalibrator]{phaseCalibrator}} 
	}
  \item{model}{
	A data frame containing the columns 'pdf' representing a hypothesised population Probability Density Function; and 'year' corresponding to the calendar years BP. 
	}
}
\value{
	Returns a single numeric log likelihood.
	}
\details{
Row names of both PD and model arguments must exactly match, since the probability of each phase given the model is calculated numerically.
	}
\examples{
	# calibrate a dataset comprising just two phases
	data <- data.frame(age=c(5800, 5100),sd=c(40, 35),phase=c('p1', 'p2'), datingType='14C')
	CalArray <- makeCalArray(shcal20, calrange = range(toy$year) ,inc=1)
	PD <- phaseCalibrator(data, CalArray)	

	# calculate toy model log likelihood
	loglik(PD, toy)
}
