% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_map.R
\name{make_map}
\alias{make_map}
\title{Create a web map using TNM services}
\usage{
make_map(
  maps,
  ...,
  protocol = c("WMTS", "WMS"),
  hydro = FALSE,
  collapse = FALSE
)
}
\arguments{
\item{maps}{'character' vector.
TNM base maps to include in the web map. Choices include
"Topo", "Imagery", "Imagery Topo", "Hydrography", "Shaded Relief", and "Blank".
See 'Details' section for a description of each base map.
By default, all base maps are included.
The one exception is the "Blank" map,
which is only accessible using a Web Map Service (WMS),
see \code{protocol} argument.}

\item{...}{Arguments to be passed to the \code{\link[leaflet:leaflet]{leaflet}} function.}

\item{protocol}{'character' string.
Standard protocol for serving pre-rendered georeferenced TNM map tiles.
Select "WMTS" for the Web Map Tile Service (the default) and "WMS" for the Web Map Service.}

\item{hydro}{'logical' flag.
Whether to show or hide (the default) the "Hydrography" overlay base map.}

\item{collapse}{'logical' flag.
Whether the layers control should be rendered as an icon that expands when hovered over.
Default is \code{FALSE}.}
}
\value{
An object of class 'leaflet', a hypertext markup language (HTML) map widget.
See example for instructions on how to add additional graphic layers
(such as points, lines, and polygons) to the map widget.
Graphic layers added to the web map must be in latitude and longitude using WGS 84
(also known as \href{https://epsg.io/4326}{EPSG:4326}).
}
\description{
Create a \href{https://leafletjs.com/}{Leaflet} map widget that includes base maps offered through
\href{https://www.usgs.gov/programs/national-geospatial-program/national-map}{The National Map} (TNM)
cached \href{https://apps.nationalmap.gov/services/}{service endpoints}.
Information about the content of these base maps can be found within the
\href{https://apps.nationalmap.gov/help/3.0\%20TNM\%20Base\%20Maps.htm}{TNM Base Maps} document.
TNM content is limited to the United States and territories.
The map widget can be rendered on HTML pages generated from R Markdown, Shiny, or other applications.
}
\details{
Composite base maps include:
\itemize{
\item "Topo" a tile base map that combines the most current TNM data,
and other public-domain data, into a multi-scale topographic reference map.
Data includes boundaries, geographic names, transportation,
contours, hydrography, land cover, shaded relief, and bathymetry.\if{html}{\out{<br/>}}
\if{latex}{\cr} \figure{basemap-topo.png}
\item "Imagery" is a tile base map of orthoimagery in TNM.
Orthoimagery data typically are high resolution aerial images that combine the
visual attributes of an aerial photograph with the spatial accuracy and reliability of a planimetric map.
USGS digital orthoimage resolution may vary from 6 inches to 1 meter.\if{html}{\out{<br/>}}
\if{latex}{\cr} \figure{basemap-imagery.png}
\item "Imagery Topo" is a tile base map of orthoimagery in TNM as a backdrop,
and a limited selection of topographic data
(boundaries, names, transportation, contours, and hydrography).\if{html}{\out{<br/>}}
\if{latex}{\cr} \figure{basemap-imagery-topo.png}
\item "Hydrography" is a overlay of cartographic representation of the
\href{https://www.usgs.gov/national-hydrography/national-hydrography-dataset}{National Hydrography Dataset} (NHD).
The NHD is a comprehensive set of digital geospatial data that encodes information about naturally occurring
and constructed bodies of surface water, paths through which water flows, related features such as
stream gages and dams, and additional hydrologic information.\if{html}{\out{<br/>}}
\if{latex}{\cr} \figure{basemap-hydrography.png}
\item "Shaded Relief" is a tile base map of terrain representation in the form of hillshades created from the
\href{https://www.usgs.gov/3d-elevation-program}{3D Elevation Program} (3DEP). 3DEP maintains a seamless dataset
of best available raster elevation data, in the form of digital elevation models (DEMs) for the conterminous
United States, Alaska, Hawaii, and Territorial Islands of the United States.\if{html}{\out{<br/>}}
\if{latex}{\cr} \figure{basemap-shaded-relief.png}
\item "OSM" is the \href{https://www.openstreetmap.org/about}{OpenStreetMap} tile base map.\if{html}{\out{<br/>}}
\if{latex}{\cr} \figure{basemap-osm.png}
\item "Blank" consists of ocean tints to give the outline of land cover as an empty base map.\if{html}{\out{<br/>}}
\if{latex}{\cr} \figure{basemap-blank.png}
}
}
\examples{
# Create map widget
map <- make_map()

# Print map widget
map

# Print map with markers
pts <- rbind(
  c(-112.049, 43.517),
  c(-122.171, 37.456),
  c( -77.367, 38.947),
  c(-149.803, 61.187),
  c( -80.248, 26.080)
)
leaflet::addMarkers(map,
  lng = pts[, 1],
  lat = pts[, 2]
)

# Print map of satellite imagery with a rectangle in the vicinity of UCLA
make_map(
  maps = "Imagery",
  collapse = TRUE
) |>
  leaflet::addRectangles(
    lng1 = -118.456,
    lat1 =   34.078,
    lng2 = -118.436,
    lat2 =   34.062,
    fillColor = "transparent"
  )
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
