% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fips-data.R
\name{fips_data}
\alias{fips_data}
\title{Retrieve state and county FIPS codes}
\usage{
fips_data(
  regions = c("states", "state", "counties", "county"),
  data_year = NULL
)
}
\arguments{
\item{regions}{The region breakdown for the map, can be one of
(\code{"states"}, \code{"state"}, \code{"counties"}, \code{"county"}).
The default is \code{"states"}.}

\item{data_year}{The year for which to obtain map data.
If the value is \code{NULL}, the most recent year's data is used. If the
provided year is not found from the available map data sets, the next most
recent year's data is used. This can be used if an older data set is being
plotted on the US map so that the data matches the map more accurately.
Therefore, the provided value should match the year of the plotted data set.
The default is \code{NULL}, i.e. the most recent available year is used.}
}
\value{
An data frame of FIPS codes of the desired \code{regions}.
}
\description{
Retrieve state and county FIPS codes
}
\examples{
str(fips_data())

state_fips <- fips_data()
county_fips <- fips_data(regions = "counties")

}
