% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impact.R
\name{impact}
\alias{impact}
\alias{ein}
\alias{cin}
\alias{ecin}
\title{Impact numbers}
\usage{
ein(.data, exposure, outcome, alpha = 0.05, ...)

cin(.data, exposure, outcome, alpha = 0.05, prevalence = NULL, ...)

ecin(.data, exposure, outcome, alpha = 0.05, ...)
}
\arguments{
\item{.data}{Either a data frame with observation-level exposure and outcome data or a \link[twoxtwo]{twoxtwo} object}

\item{exposure}{Name of exposure variable; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{outcome}{Name of outcome variable; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{alpha}{Significance level to be used for constructing confidence interval; default is \code{0.05}}

\item{...}{Additional arguments passed to \link[twoxtwo]{twoxtwo} function; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{prevalence}{Prevalence of exposure in the population; must be numeric between \code{0} and \code{1}; only used in \code{cin()}; default is \code{NULL} and will be ignored}
}
\value{
A \code{tibble} with the following columns:
\itemize{
\item \strong{measure}: Name of the measure calculated
\item \strong{estimate}: Point estimate for the impact number
\item \strong{ci_lower}: The lower bound of the confidence interval for the estimate
\item \strong{ci_upper}: The upper bound of the confidence interval for the estimate
\item \strong{exposure}: Name of the exposure variable followed by +/- levels (e.g. smoking::yes/no)
\item \strong{outcome}: Name of the outcome variable followed by +/- levels (e.g. heart_disease::yes/no)
}
}
\description{
Impact numbers are designed to communicate how impactful interventions and/or exposures can be on a population. The \link[twoxtwo]{twoxtwo} framework allows for calculation of impact numbers: exposure impact number (EIN), case impact number (CIN), and the exposed cases impact number (ECIN).

The \code{ein()}, \code{cin()}, and \code{ecin()} functions provide interfaces for calculating impact number estimates. Each function takes an input dataset and arguments for outcome and exposure as bare, unquoted variable names. If the input has the  \link[twoxtwo]{twoxtwo} class then the measures will be calculated using exposure and outcome information from that object. The functions all return a tidy \code{tibble} with the name of the measure, the point estimate, and lower/upper bounds of a confidence interval (CI) based on the SE.

Formulas used in point estimate and SE calculations are available in 'Details'.
}
\details{
The formulas below denote cell values as A,B,C,D. For more on \code{twoxtwo} notation see the \link[twoxtwo]{twoxtwo} documentation.

Note that formulas for standard errors are not provided below but are based on forumlas described in Hildebrandt et al (2006).
\subsection{Exposure Impact Number (EIN)}{

\deqn{EIN = 1/((A/(A+B)) - (C/(C+D)))}
}

\subsection{Case Impact Number (CIN)}{

\deqn{CIN = 1/(((A+C)/(A+B+C+D))-(C/(C+D)))) / ((A+C)/(A+B+C+D))}

If "prevalence" argument is not \code{NULL} then the formula uses the value specified for prevalence of exposure (p):

\deqn{CIN = 1/ ((p * (((A/(A+B)) / (C/(C+D))) - 1)) / (p * (((A/(A+B)) / (C/(C+D))) - 1) + 1))}
}

\subsection{Exposed Cases Impact Number (ECIN)}{

\deqn{ECIN = 1/(1 - (1/((A/(A+B)) / (C/(C+D)))))}
}
}
\references{
Hildebrandt, M., Bender, R., Gehrmann, U., & Blettner, M. (2006). Calculating confidence intervals for impact numbers. BMC medical research methodology, 6, 32. https://doi.org/10.1186/1471-2288-6-32

Heller, R. F., Dobson, A. J., Attia, J., & Page, J. (2002). Impact numbers: measures of risk factor impact on the whole population from case-control and cohort studies. Journal of epidemiology and community health, 56(8), 606–610. https://doi.org/10.1136/jech.56.8.606
}
