% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fvYearCompSingleCF.R
\name{fvYearlyCompSingleCF}
\alias{fvYearlyCompSingleCF}
\title{Computing Future Value of a Single Cash Flow with Yearly Compounding Frequency.}
\usage{
fvYearlyCompSingleCF(r, n, pv)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pv}{A number.}
}
\value{
Input values to three arguments \code{r} , \code{n} and \code{pv}.
}
\description{
Computing Future Value of a Single Cash Flow with Yearly Compounding Frequency.
}
\details{
As \insertCite{brook;textual}{tvmComp} explains Future Value  is the cash value of an money or an asset in the future that is equivalent in value to a specific amount today. This, acts as basis of understanding how interest accumulates (and gets compounded) and how the Time Value of Money equation can be used for estimating growth. On these lines, \code{fvYearlyCompSingleCF()} was developed and it calculates Future Value of a Single Cash Flow with Yearly Compounding Frequency.
\code{fvYearlyCompSingleCF()} gives Future Value when values are passed to its three arguments. Here \code{r} is annual rate,  \code{n} is number of years and \code{pv} is Present Value
}
\examples{
fvYearlyCompSingleCF(0.08,10,2000)
fvYearlyCompSingleCF(0.08,10,-2000)
}
\references{
\insertRef{brook}{tvmComp}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
