% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textBoxPlacement.R
\name{permuteCurves}
\alias{permuteCurves}
\title{permuteCurves}
\usage{
permuteCurves(xList, yList, tList, textBoxHeights, permInd)
}
\arguments{
\item{xList}{list whose components are numeric vectors of the x values for overlaid curves}

\item{yList}{list whose components are numeric vectors of the y values for overlaid curves}

\item{tList}{list of character string texts to insert in plot}

\item{textBoxHeights}{return value of textBoxUserUnits()}

\item{permInd}{return value of permInd()}
}
\value{
returns a list whose (re-ordered) components are:
\itemize{
\item xList a list of numeric vector for x values
\item yList a list of numeric vector for y values - re-ordered and offset-adjusted
\item tList a list of character strings for text boxes to label the curves
\item offset a numeric vector offset to add to each staggered curve
\item ystart a numeric vector of starting positions
}
}
\description{
reorder multiple curves so that the curve with the largest y range is on the bottom
of the staggered graph
}
\examples{

units<-textBoxUserUnits(textList,yrange(yList1),verbose=TRUE)
permuteCurves(xList1,yList1,textList,units,permInd(yrange(yList1)))


}
